/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.emclient.authentication;

import com.aeontronix.commons.URLBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.authentication.AnypointUsernamePasswordCredentials;
import com.aeontronix.enhancedmule.tools.authentication.Credentials;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.emclient.authentication.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CredentialsProviderAnypointUsernamePasswordImpl
implements AnypointBearerTokenCredentialsProvider {
    private String username;
    private String password;

    public CredentialsProviderAnypointUsernamePasswordImpl(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Credentials getCredentials() throws IOException {
        return new AnypointUsernamePasswordCredentials(this.username, this.password);
    }

    @Override
    public AuthenticationHandler toAuthenticationHandler(RESTClient restClient, String anypointPlatformUrl) {
        return new AuthenticationProviderUsernamePasswordImpl(this.username, this.password);
    }

    @Override
    public String getAnypointBearerToken(EnhancedMuleClient emClient) throws IOException {
        try {
            String loginUrl = new URLBuilder(emClient.getAnypointPlatformUrl()).path("/accounts/login").toString();
            HashMap<String, String> loginReq = new HashMap<String, String>();
            loginReq.put("username", this.username);
            loginReq.put("password", this.password);
            Map response = (Map)emClient.getRestClient().post(loginUrl).jsonBody(loginReq).executeAndConvertToObject(Map.class);
            String accessToken = (String)response.get("access_token");
            if (accessToken == null) {
                throw new IOException("No access token returned by anypoint login");
            }
            return accessToken;
        }
        catch (RESTException | JsonConvertionException e) {
            throw new IOException(e);
        }
    }
}

