/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.anypoint.api;

import com.aeontronix.commons.exception.InvalidStateException;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointObject;
import com.aeontronix.enhancedmule.tools.anypoint.api.DesignCenterProject;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignCenterProjectExchange
extends AnypointObject<DesignCenterProject> {
    public static final Pattern majorVersionRegex = Pattern.compile("(\\d*?)\\.");
    private final String branch;
    private String main;
    private String name;
    private String classifier;
    private String groupId;
    private String assetId;
    private String version;
    private String apiVersion;
    private String nextVersion;
    private boolean enableCreatePlatformApis;
    private boolean isPublishedVersion;

    public DesignCenterProjectExchange(DesignCenterProject designCenterProject, String branch) {
        super(designCenterProject);
        this.branch = branch;
    }

    @JsonIgnore
    public String getBranch() {
        return this.branch;
    }

    @JsonProperty
    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @JsonProperty
    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty
    public String getNextVersion() {
        return this.nextVersion;
    }

    public void setNextVersion(String nextVersion) {
        this.nextVersion = nextVersion;
    }

    @JsonProperty
    public boolean isEnableCreatePlatformApis() {
        return this.enableCreatePlatformApis;
    }

    public void setEnableCreatePlatformApis(boolean enableCreatePlatformApis) {
        this.enableCreatePlatformApis = enableCreatePlatformApis;
    }

    @JsonProperty
    public boolean isPublishedVersion() {
        return this.isPublishedVersion;
    }

    public void setPublishedVersion(boolean publishedVersion) {
        this.isPublishedVersion = publishedVersion;
    }

    public void publish() throws HttpException {
        this.publish(null, null);
    }

    public void publish(String version, String apiVersion) throws HttpException {
        if (version == null) {
            version = this.nextVersion;
        }
        if (apiVersion == null) {
            Matcher m = majorVersionRegex.matcher(version);
            if (!m.find()) {
                throw new InvalidStateException("Invalid version " + version);
            }
            apiVersion = "v" + m.group(1);
        }
        ((DesignCenterProject)this.parent).publishExchange(this.branch, this.assetId, this.name, this.main, version, apiVersion);
    }
}

