/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.application.api;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.anypoint.api.API;
import com.aeontronix.enhancedmule.tools.anypoint.api.APIContract;
import com.aeontronix.enhancedmule.tools.anypoint.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.anypoint.api.SLATier;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.AssetInstance;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAsset;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIAccessDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientApplicationDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ClientApplicationDescriptor.class);
    private static final EMTLogger plogger = new EMTLogger(logger);
    private String url;
    private String description;
    private String name;
    private boolean injectClientIdSec = true;
    private String clientIdProperty;
    private String clientSecretProperty;
    private List<APIAccessDescriptor> access;

    public ClientApplicationDescriptor() {
    }

    public ClientApplicationDescriptor(String url, String description, String name) {
        this.url = url;
        this.description = description;
        this.name = name;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(defaultValue="true")
    public boolean isInjectClientIdSec() {
        return this.injectClientIdSec;
    }

    public void setInjectClientIdSec(boolean injectClientIdSec) {
        this.injectClientIdSec = injectClientIdSec;
    }

    @JsonProperty
    public String getClientIdProperty() {
        return this.clientIdProperty;
    }

    public void setClientIdProperty(String clientIdProperty) {
        this.clientIdProperty = clientIdProperty;
    }

    @JsonProperty
    public String getClientSecretProperty() {
        return this.clientSecretProperty;
    }

    public void setClientSecretProperty(String clientSecretProperty) {
        this.clientSecretProperty = clientSecretProperty;
    }

    @JsonProperty(value="access")
    public synchronized List<APIAccessDescriptor> getAccess() {
        return this.access != null ? this.access : Collections.emptyList();
    }

    public synchronized void setAccess(List<APIAccessDescriptor> access) {
        this.access = access;
    }

    public synchronized ClientApplicationDescriptor addAccess(APIAccessDescriptor accessDescriptor) {
        if (this.access == null) {
            this.access = new ArrayList<APIAccessDescriptor>();
        }
        this.access.add(accessDescriptor);
        return this;
    }

    public synchronized ClientApplicationDescriptor addAccess(API api) {
        this.addAccess(new APIAccessDescriptor(api, null));
        return this;
    }

    public synchronized ClientApplicationDescriptor addAccess(API api, String slaTier) {
        this.addAccess(new APIAccessDescriptor(api, slaTier));
        return this;
    }

    public void provision(ApplicationDescriptor applicationDescriptor, Environment environment, ProvisioningRequest request, APIProvisioningResult result) throws ProvisioningException {
        block28: {
            try {
                String appId = applicationDescriptor.getId();
                if (this.name == null) {
                    this.name = appId + "-" + environment.getLName();
                }
                ClientApplication clientApplication = null;
                try {
                    clientApplication = environment.getOrganization().findClientApplicationByName(this.name);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (clientApplication == null) {
                    plogger.info(EMTLogger.Product.API_MANAGER, "Client application: {}", this.name);
                    logger.debug("Client application not found, creating: " + this.name);
                    String instanceId = null;
                    if (this.access != null && !this.access.isEmpty()) {
                        instanceId = this.findAPIInstance(environment, this.access.get(0)).getId();
                    }
                    try {
                        clientApplication = environment.getOrganization().createClientApplication(this.name, this.url, this.description, instanceId);
                    }
                    catch (HttpException e) {
                        if (e.getStatusCode() == 502) {
                            clientApplication = this.handleClientAppCreatedInWrongOrg(environment);
                            if (clientApplication == null) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                    plogger.info(EMTLogger.Product.API_MANAGER, "Created client application: {}", this.name);
                } else {
                    plogger.info(EMTLogger.Product.API_MANAGER, "Client application already exists: {}", this.name);
                }
                result.setClientApplication(clientApplication);
                if (this.access == null) break block28;
                for (APIAccessDescriptor accessDescriptor : this.access) {
                    boolean approve;
                    String labelLogStr = StringUtils.isNotBlank((String)accessDescriptor.getLabel()) ? " with label " + accessDescriptor.getLabel() : "";
                    String apiAccessLogStr = "API contract to " + accessDescriptor.getAssetId() + labelLogStr + " using client application " + clientApplication.getName();
                    plogger.info(EMTLogger.Product.API_MANAGER, "Client application access: {}", apiAccessLogStr);
                    AssetInstance instance = this.findAPIInstance(environment, accessDescriptor);
                    logger.debug("Found instance {}", (Object)instance);
                    Environment apiEnv = new Environment(new Organization(environment.getClient(), instance.getOrganizationId()), instance.getEnvironmentId());
                    API accessedAPI = new API(apiEnv);
                    accessedAPI.setId(instance.getId());
                    accessedAPI.setAssetId(instance.getAssetId());
                    logger.debug("Found apiEnv {} with id {}", (Object)apiEnv, (Object)apiEnv.getId());
                    APIContract contract = null;
                    try {
                        contract = accessedAPI.findContract(clientApplication);
                    }
                    catch (NotFoundException notFoundException) {
                    }
                    catch (UnauthorizedHttpException e) {
                        logger.warn("Unable to List contracts of api " + accessedAPI.getAssetId() + " due to lack of permissions: " + e.getMessage());
                    }
                    if (contract == null) {
                        plogger.info(EMTLogger.Product.API_MANAGER, "Client application access missing, requesting: {}", apiAccessLogStr);
                        SLATier slaTier = null;
                        if (accessDescriptor.getSlaTier() != null) {
                            slaTier = instance.findSLATier(accessDescriptor.getSlaTier());
                        } else {
                            List<SLATier> slaTiers = instance.findSLATiers();
                            if (slaTiers.size() == 1) {
                                slaTier = instance.findSLATier(slaTiers.iterator().next().getName());
                            } else if (slaTiers.size() > 1) {
                                throw new ProvisioningException("Accessed API " + instance.getAssetId() + " has multiple SLA tiers, you must specify which is to be used");
                            }
                        }
                        contract = clientApplication.requestAPIAccess(accessedAPI, instance, slaTier);
                        plogger.info(EMTLogger.Product.API_MANAGER, "Created {}", apiAccessLogStr);
                    } else {
                        plogger.info(EMTLogger.Product.API_MANAGER, "Client application contract already exists: {}", apiAccessLogStr);
                    }
                    boolean bl = approve = accessDescriptor.getApprove() != null ? accessDescriptor.getApprove().booleanValue() : request.isAutoApproveAPIAccessRequest();
                    if (!contract.isApproved() && approve) {
                        try {
                            if (contract.isRevoked()) {
                                contract.restoreAccess();
                                plogger.info(EMTLogger.Product.API_MANAGER, "Restored approval to {}", apiAccessLogStr);
                                continue;
                            }
                            contract.approveAccess();
                            plogger.info(EMTLogger.Product.API_MANAGER, "Approved to {}", apiAccessLogStr);
                            continue;
                        }
                        catch (HttpException e) {
                            if (e.getStatusCode() == 403) {
                                plogger.info(EMTLogger.Product.API_MANAGER, "Unable to approve access {} due to lack of permissions: {}", apiAccessLogStr, e.getMessage());
                                continue;
                            }
                            throw e;
                        }
                    }
                    plogger.info(EMTLogger.Product.API_MANAGER, "Contract for {} already exists and is pending approval (id={})", apiAccessLogStr, contract.getId());
                }
            }
            catch (NotFoundException | HttpException e) {
                throw new ProvisioningException(e);
            }
        }
    }

    private ClientApplication handleClientAppCreatedInWrongOrg(Environment environment) throws HttpException, ProvisioningException {
        for (Organization org : environment.getClient().findOrganizations()) {
            if (org.getId().equals(environment.getOrganization().getId())) continue;
            try {
                ClientApplication clientApp = org.findClientApplicationByName(this.name);
                logger.warn("Client application was erroneously created under org " + org.getName() + ", please delete it so that it may be recreated under master org");
                return clientApp;
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return null;
    }

    private AssetInstance findAPIInstance(Environment environment, APIAccessDescriptor accessDescriptor) throws HttpException, NotFoundException {
        String accessEnvId;
        Organization accessOrg;
        logger.debug("Processing access descriptor : {}", (Object)accessDescriptor);
        if (accessDescriptor.getOrgId() == null) {
            if (accessDescriptor.getGroupId() != null) {
                accessDescriptor.setOrgId(accessDescriptor.getGroupId());
            }
            logger.debug("Access descriptor has no org id, getting the default org");
            accessOrg = environment.getOrganization();
            accessDescriptor.setOrgId(accessOrg.getId());
        } else {
            accessOrg = environment.getOrganization().getClient().findOrganizationById(accessDescriptor.getOrgId());
        }
        if (StringUtils.isBlank((String)accessDescriptor.getAssetId())) {
            throw new IllegalArgumentException("access descriptor missing assetId");
        }
        logger.debug("Access org = {}", (Object)accessOrg.getId());
        if (accessDescriptor.getGroupId() == null) {
            logger.debug("No group id found, using the org id instead");
            accessDescriptor.setGroupId(accessOrg.getId());
        }
        logger.debug("Access group id = {}", (Object)accessDescriptor.getGroupId());
        if (StringUtils.isNotBlank((String)accessDescriptor.getEnv())) {
            accessEnvId = accessOrg.findEnvironmentByNameOrId(accessDescriptor.getEnv()).getId();
            logger.debug("access environment specified");
        } else {
            logger.debug("No access environment specified, using the API's environment");
            accessEnvId = environment.getId();
        }
        logger.debug("Access environment id = {}", (Object)accessEnvId);
        ExchangeAsset exchangeAsset = accessOrg.findExchangeAsset(accessDescriptor.getGroupId(), accessDescriptor.getAssetId(), accessDescriptor.getAssetVersion());
        logger.debug("Found exchangeAsset {}", (Object)exchangeAsset);
        logger.debug("exchangeAsset instances: {}", exchangeAsset.getInstances());
        try {
            return exchangeAsset.findInstances(accessDescriptor.getLabel(), accessEnvId);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Unable to find instances for accessed API " + accessDescriptor);
        }
    }
}

