/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.APISpecSource;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ExchangeApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.FileApplicationSource;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationSource
implements APISpecSource,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationSource.class);
    protected LegacyAnypointClient client;
    protected ApplicationIdentifier applicationIdentifier;

    public ApplicationSource(LegacyAnypointClient client) {
        this.client = client;
    }

    public static ApplicationSource create(String orgId, LegacyAnypointClient client, String path) throws IOException {
        if (path.startsWith("exchange://")) {
            return new ExchangeApplicationSource(orgId, client, path);
        }
        return new FileApplicationSource(client, new File(path));
    }

    public abstract String getFileName();

    public abstract File getLocalFile() throws IOException;

    public abstract boolean exists();

    public abstract ObjectNode getAnypointDescriptor() throws IOException, HttpException;

    @Nullable
    protected ObjectNode readDescriptorFromZip(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry anypointJson = zipFile.getEntry("anypoint.json");
        if (anypointJson != null) {
            try (InputStream is = zipFile.getInputStream(anypointJson);){
                ObjectNode objectNode = (ObjectNode)this.client.getJsonHelper().getJsonMapper().readTree(is);
                return objectNode;
            }
        }
        return null;
    }

    public String getArtifactId() {
        ApplicationIdentifier applicationIdentifier = this.getApplicationIdentifier();
        if (applicationIdentifier != null) {
            return applicationIdentifier.getArtifactId();
        }
        return null;
    }

    public abstract ApplicationIdentifier getApplicationIdentifier();

    public abstract Map<String, Object> getSourceJson(JsonHelper var1);

    @Override
    public Set<String> listAPISpecFiles() throws IOException {
        HashSet<String> files = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = new ZipFile(this.getLocalFile()).entries();
        while (entries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().toLowerCase().startsWith("api/") || !StringUtils.isNotBlank((String)(name = zipEntry.getName().substring(4)))) continue;
            files.add(name);
        }
        return files;
    }

    @Override
    public void writeAPISpecFile(String name, OutputStream os) throws IOException {
        try (ZipFile zipFile = new ZipFile(this.getLocalFile());){
            ZipEntry entry = zipFile.getEntry("api/" + name);
            IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)os);
        }
    }

    public abstract com.aeontronix.anypointsdk.amc.application.ApplicationSource toSDKSource();
}

