/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.legacy.deploy;

import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileApplicationSource
extends ApplicationSource {
    private static final Logger logger = LoggerFactory.getLogger(FileApplicationSource.class);
    private File file;

    public FileApplicationSource(LegacyAnypointClient client, File file) {
        super(client);
        this.file = file;
    }

    public FileApplicationSource(LegacyAnypointClient client, File file, ApplicationIdentifier applicationIdentifier) {
        this(client, file);
        this.applicationIdentifier = applicationIdentifier;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public File getLocalFile() throws IOException {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public ObjectNode getAnypointDescriptor() throws IOException {
        return this.readDescriptorFromZip(this.file);
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() {
        block10: {
            if (this.applicationIdentifier == null) {
                logger.debug("no application identifier found, reading from pom");
                try {
                    ZipFile zipFile = new ZipFile(this.file);
                    ZipEntry artJson = zipFile.getEntry("META-INF/mule-artifact/mule-artifact.json");
                    if (artJson == null) break block10;
                    try (InputStream is = zipFile.getInputStream(artJson);){
                        String[] name;
                        ObjectNode jsonNode = (ObjectNode)this.client.getJsonHelper().getJsonMapper().readTree(is);
                        JsonNode nameJson = jsonNode.get("name");
                        if (nameJson != null && !nameJson.isNull() && (name = nameJson.textValue().split(":")).length == 3) {
                            this.applicationIdentifier = new ApplicationIdentifier(name[0], name[1], name[2]);
                            logger.debug("Loaded ApplicationIdentifier from archive: " + this.applicationIdentifier);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
        }
        return this.applicationIdentifier;
    }

    @Override
    public Map<String, Object> getSourceJson(JsonHelper jsonHelper) {
        throw new UnsupportedOperationException("getSourceJson() not supported for file source");
    }

    @Override
    public com.aeontronix.anypointsdk.amc.application.ApplicationSource toSDKSource() {
        return new com.aeontronix.anypointsdk.amc.application.FileApplicationSource(this.file);
    }

    @Override
    public void close() throws IOException {
    }
}

