/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.enhancedmule.tools.util.StreamSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileStreamSource
implements StreamSource {
    private File file;

    public FileStreamSource(File file) {
        this.file = file;
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + file.exists());
        }
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }
}

