/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.exchange;

import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.cli.AbstractCommand;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="promote", description={"Promote an snapshot application in exchange to a release version"})
public class ExchangePromoteApplicationCmd
extends AbstractCommand
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ExchangePromoteApplicationCmd.class);
    @CommandLine.Option(names={"-g", "--group-id"}, description={"Business group name or id"})
    private String businessGroup;
    @CommandLine.Parameters(index="0", arity="1", description={"Asset Id"})
    private String assetId;
    @CommandLine.Parameters(index="1", arity="1", description={"Asset Version"})
    private String version;
    @CommandLine.Option(names={"-n", "--new-version"}, description={"New version"})
    private String newVersion;

    @Override
    public Integer call() throws Exception {
        Organization org;
        EnhancedMuleClient emClient = this.getCli().createEMClient();
        LegacyAnypointClient legacyAnypointClient = emClient.getLegacyAnypointClient();
        if (this.businessGroup != null) {
            org = legacyAnypointClient.findOrganizationByNameOrId(this.businessGroup);
        } else {
            org = legacyAnypointClient.getUser().getOrganization();
            org.setClient(legacyAnypointClient);
        }
        org.promoteExchangeApplication(this.getCli().getAnypointClient(), emClient, org.getId(), this.assetId, this.version, this.newVersion);
        return 0;
    }
}

