/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.emclient.authentication;

import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProviderConnectedAppsImpl;
import com.aeontronix.enhancedmule.tools.authentication.AccessTokenCredentials;
import com.aeontronix.enhancedmule.tools.authentication.Credentials;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.emclient.authentication.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.restclient.RESTClient;
import com.aeontronix.restclient.RESTClientRequestBuilder;
import com.aeontronix.restclient.RESTException;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.json.JsonConvertionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CredentialsProviderClientCredentialsImpl
implements AnypointBearerTokenCredentialsProvider {
    private String clientId;
    private String clientSecret;

    public CredentialsProviderClientCredentialsImpl(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public Credentials getCredentials() throws IOException {
        return new AccessTokenCredentials(this.clientId, this.clientSecret);
    }

    @Override
    public AuthenticationHandler toAuthenticationHandler(RESTClient restClient, String anypointPlatformUrl) {
        return new AuthenticationProviderConnectedAppsImpl(restClient, anypointPlatformUrl, this.clientId, this.clientSecret);
    }

    @Override
    public String getAnypointBearerToken(EnhancedMuleClient emClient) throws IOException {
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("grant_type", "client_credentials");
            body.put("client_id", this.clientId);
            body.put("client_secret", this.clientSecret);
            return (String)((Map)((RESTClientRequestBuilder)emClient.getAnypointRestClient().post("/accounts/api/v2/oauth2/token").jsonBody(body).authenticationHandler(null)).executeAndConvertToObject(Map.class)).get("access_token");
        }
        catch (RESTException | JsonConvertionException e) {
            throw new IOException(e);
        }
    }
}

