/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.onprem;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.exception.ProcessExecutionFailedException;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.onprem.MuleRuntimeInstallationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleRuntimeInstaller {
    public static final String INSTANCE_NAME = "instance-name.txt";
    public static final String INSTANCE_VERSION = "instance-version.txt";
    private static final Logger logger = LoggerFactory.getLogger(MuleRuntimeInstaller.class);
    private final String name;
    private final boolean windows;
    private File basedir;
    private File runtimeDir;
    private File runtimeArchive;
    private File archiveDir;
    private File target;
    private String registrationToken;
    private boolean upgrade;
    private File upgradeDir;
    private boolean force;
    private String version;
    private File licenseFile;

    public MuleRuntimeInstaller(String name, File runtimeArchive, File basedir, File runtimeDir, String registrationToken) {
        this.name = name;
        this.runtimeArchive = runtimeArchive;
        this.basedir = basedir;
        this.runtimeDir = runtimeDir;
        this.registrationToken = registrationToken;
        this.windows = System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            File[] children;
            if (to.exists()) {
                if (!to.isDirectory()) {
                    throw new IOException(to.getAbsolutePath() + " already exists and is file rather than a directory");
                }
            } else {
                FileUtils.mkdirs((File)to);
            }
            if ((children = from.listFiles()) != null) {
                for (File child : children) {
                    MuleRuntimeInstaller.copy(child, new File(to, child.getName()));
                }
            }
        } else {
            FileUtils.copy((File)from, (File)to);
        }
    }

    public void install() throws MuleRuntimeInstallationException {
        try {
            if (this.basedir == null) {
                this.basedir = new File(this.windows ? "C:\\mule" : "/opt/mule");
            }
            if (this.name == null) {
                throw new MuleRuntimeInstallationException("Name not specified nor couldn't be automatically generated");
            }
            if (this.runtimeDir == null) {
                this.runtimeDir = new File(this.basedir, this.name);
            }
            if (this.archiveDir == null) {
                this.archiveDir = new File(this.basedir, "archive");
            }
            this.downloadArchive();
            this.upgrade();
            this.unzip(this.runtimeArchive, this.runtimeDir);
            this.configure();
        }
        catch (ProcessExecutionFailedException | IOException e) {
            throw new MuleRuntimeInstallationException(e);
        }
    }

    private void upgrade() throws IOException, ProcessExecutionFailedException, MuleRuntimeInstallationException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        this.upgradeDir = new File(this.runtimeDir.getPath() + ".old" + formatter.format(LocalDateTime.now()));
        if (this.upgrade) {
            this.runMuleCmd("mule", "stop");
            this.runMuleCmd("mule", "remove");
            logger.info("Moving {} to {}", (Object)this.runtimeDir.getPath(), (Object)this.upgradeDir.getPath());
            if (this.upgradeDir.exists()) {
                FileUtils.delete((File[])new File[]{this.upgradeDir});
            }
            Files.move(this.runtimeDir.toPath(), this.upgradeDir.toPath(), new CopyOption[0]);
        } else if (this.runtimeDir.exists()) {
            if (this.force) {
                FileUtils.delete((File[])new File[]{this.runtimeDir});
            } else {
                throw new MuleRuntimeInstallationException("Runtime already exists, use force install to delete prior to installation");
            }
        }
    }

    private void downloadArchive() throws IOException, MuleRuntimeInstallationException {
        if (this.runtimeArchive == null) {
            if (this.version == null) {
                throw new MuleRuntimeInstallationException("either archive or version must be set");
            }
            String filename = "mule-ee-distribution-standalone-" + this.version + ".zip";
            if (!this.archiveDir.exists()) {
                FileUtils.mkdirs((File)this.archiveDir);
            }
            this.runtimeArchive = new File(this.archiveDir, filename);
            if (!this.runtimeArchive.exists()) {
                logger.info("Downloading runtime version " + this.version + " to " + this.runtimeArchive.getPath());
                URLConnection urlConnection = new URL("https://s3.amazonaws.com/new-mule-artifacts/" + filename).openConnection();
                try (InputStream is = urlConnection.getInputStream();
                     FileOutputStream fos = new FileOutputStream(this.runtimeArchive);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                }
                logger.info("Archive download complete");
            }
        }
    }

    private void configure() throws IOException, MuleRuntimeInstallationException, ProcessExecutionFailedException {
        logger.info("Configuring runtime");
        FileUtils.write((File)new File(this.runtimeDir, INSTANCE_NAME), (String)this.name);
        FileUtils.write((File)new File(this.runtimeDir, INSTANCE_VERSION), (String)this.version);
        String winFullName = "Mule " + this.name;
        this.modifyRuntimeFile("conf/wrapper.conf", txt -> txt.replaceFirst("wrapper\\.ntservice\\.name=.*", "wrapper.ntservice.name=" + winFullName.replaceAll("\\s", "")).replaceFirst("wrapper\\.ntservice\\.displayname=.*", "wrapper.ntservice.displayname=" + winFullName));
        if (this.registrationToken != null) {
            if (this.upgrade) {
                throw new MuleRuntimeInstallationException("Upgrade mustn't be used in conjunction with registrationToken");
            }
            this.runMuleCmd("amc_setup", "-H", this.registrationToken, this.name);
        }
        if (this.upgrade) {
            this.upgradeCopy("conf/mule-agent.yml", false);
            this.upgradeCopy("domains", false);
            this.upgradeCopy("conf/mule-agent.jks", false);
            this.upgradeCopy("conf/anypoint-truststore.jks", false);
            this.upgradeCopy("conf/truststore.jks", true);
            this.upgradeCopy("server-plugins/mule-agent-plugin", false);
            this.runMuleCmd("amc_setup", "-U");
        }
        File archivedLicense = new File(this.archiveDir, "license.lic");
        if (this.licenseFile == null && archivedLicense.exists()) {
            this.licenseFile = archivedLicense;
        }
        if (this.licenseFile != null) {
            if (!this.licenseFile.exists()) {
                throw new MuleRuntimeInstallationException("License file not found:" + this.licenseFile.getPath());
            }
            if (!archivedLicense.getParentFile().exists()) {
                FileUtils.mkdirs((File)archivedLicense.getParentFile());
            }
            FileUtils.copy((File)this.licenseFile, (File)archivedLicense);
            FileUtils.copy((File)this.licenseFile, (File)new File(this.runtimeDir + File.separator + "bin" + File.separator + "license.lic"));
            this.runMuleCmd("mule", "-installLicense license.lic");
        }
        if (this.windows) {
            this.runMuleCmd("mule", "install");
            this.runCmd(new File("."), "net start \"" + winFullName + "\"");
        }
    }

    private void runMuleCmd(String command, String ... params) throws IOException, ProcessExecutionFailedException {
        StringBuilder buf = new StringBuilder();
        if (this.windows) {
            File cmd = new File(this.runtimeDir + File.separator + "bin" + File.separator + command + ".bat");
            if (!cmd.exists()) {
                throw new IOException("file not found: " + cmd.getPath());
            }
            buf.append(cmd.getAbsolutePath());
        } else {
            buf.append("sh ").append(command);
        }
        buf.append(" ").append(String.join((CharSequence)" ", params));
        File workDir = new File(this.runtimeDir, "bin");
        this.runCmd(workDir, buf.toString());
    }

    private void runCmd(File workDir, String cmdLineStr) throws IOException {
        CommandLine cmdLine = CommandLine.parse((String)cmdLineStr);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workDir);
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out));
        int execute = executor.execute(cmdLine);
    }

    private void upgradeCopy(String path, boolean optional) throws MuleRuntimeInstallationException, IOException {
        String npath = path.replace("/", File.separator);
        File old = new File(this.upgradeDir.getPath() + File.separator + npath);
        if (!old.exists()) {
            if (optional) {
                return;
            }
            throw new MuleRuntimeInstallationException("File not found: " + old.getPath());
        }
        File newFile = new File(this.runtimeDir + File.separator + npath);
        MuleRuntimeInstaller.copy(old, newFile);
    }

    public void modifyRuntimeFile(String path, Function<String, String> function) throws IOException {
        File runtimeFile = new File(this.runtimeDir.getPath() + File.separator + path.replace("/", File.separator));
        String content = FileUtils.toString((File)runtimeFile);
        FileUtils.write((File)runtimeFile, (String)function.apply(content));
    }

    public String getName() {
        return this.name;
    }

    public File getRuntimeDir() {
        return this.runtimeDir;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public File getRuntimeArchive() {
        return this.runtimeArchive;
    }

    public void setRuntimeArchive(File runtimeArchive) {
        this.runtimeArchive = runtimeArchive;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public String getRegistrationToken() {
        return this.registrationToken;
    }

    public void setRegistrationToken(String registrationToken) {
        this.registrationToken = registrationToken;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public File getArchiveDir() {
        return this.archiveDir;
    }

    public void setArchiveDir(File archiveDir) {
        this.archiveDir = archiveDir;
    }

    public void unzip(File zipFile, File destDir) throws IOException {
        logger.info("Unzipping archive");
        if (!destDir.exists()) {
            FileUtils.mkdirs((File)destDir);
        }
        try (FileInputStream fis = new FileInputStream(zipFile);){
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                boolean binFile;
                String fileName = ze.getName().replaceFirst(".*?/", "").replace("/", File.separator);
                boolean valid = StringUtils.isNotBlank((String)fileName);
                boolean bl = binFile = fileName.length() > 4 && fileName.startsWith("bin/");
                if (binFile && !this.windows && fileName.endsWith(".bat")) {
                    valid = false;
                }
                if (valid) {
                    File newFile = new File(destDir + File.separator + fileName);
                    if (ze.isDirectory()) {
                        if (!newFile.exists()) {
                            FileUtils.mkdirs((File)newFile);
                        }
                    } else {
                        File parent = newFile.getParentFile();
                        if (!parent.exists()) {
                            FileUtils.mkdirs((File)parent);
                        }
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            IOUtils.copy((InputStream)zis, (OutputStream)fos);
                        }
                    }
                    zis.closeEntry();
                    if (!this.windows && !fileName.contains(".")) {
                        newFile.setExecutable(true);
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
    }
}

