/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.role;

import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RoleAssignmentAddition {
    private final Map<String, String> contextParams = new HashMap<String, String>();
    private String roleId;

    public RoleAssignmentAddition(String roleId, Environment environment) {
        this.roleId = roleId;
        if (environment != null) {
            this.contextParams.put("org", ((Organization)environment.getParent()).getId());
            this.contextParams.put("envId", environment.getId());
        }
    }

    @JsonProperty(value="role_id")
    public String getRoleId() {
        return this.roleId;
    }

    @JsonProperty(value="context_params")
    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    @JsonIgnore
    public String getEnvironmentId() {
        return this.contextParams.get("envId");
    }

    public String toString() {
        return "RoleAssignmentAddition{contextParams=" + this.contextParams + ", roleId='" + this.roleId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleAssignmentAddition that = (RoleAssignmentAddition)o;
        return Objects.equals(this.contextParams, that.contextParams) && Objects.equals(this.roleId, that.roleId);
    }

    public int hashCode() {
        return Objects.hash(this.contextParams, this.roleId);
    }
}

