/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.exchange;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.anypointsdk.exchange.CreateExchangeAssetRequest;
import com.aeontronix.enhancedmule.tools.cli.AbstractOrgCommand;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="publish", aliases={"p"}, description={"Publish an exchange asset"})
public class ExchangePublishAssetCmd
extends AbstractOrgCommand
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ExchangePublishAssetCmd.class);
    @CommandLine.Option(names={"-u", "--group-id"}, description={"Group Id"})
    private String groupId;
    @CommandLine.Option(names={"-a", "--asset-id"}, description={"Asset Id"})
    private String assetId;
    @CommandLine.Option(names={"-v", "--version"}, description={"Version"})
    private String version;
    @CommandLine.Option(names={"-n", "--name"}, description={"Name"})
    private String name;
    @CommandLine.Option(names={"-d", "--description"}, description={"Description"})
    private String description;
    @CommandLine.Option(names={"-t", "--type"}, description={"Type"})
    private String type;
    @CommandLine.Option(names={"-p", "--dependency"}, description={"Dependencies"})
    private List<String> dependencies;
    @CommandLine.Option(names={"-w", "--keyword"}, description={"Keywords"})
    private List<String> keywords;
    @CommandLine.Option(names={"-g", "--tags"}, description={"Tags"})
    private List<String> tags;
    @CommandLine.Option(names={"-F"}, description={"Fields (use comma seperated list for multiple values)"})
    private Map<String, String> fields;
    @CommandLine.Option(names={"-C"}, description={"Categories (use comma seperated list for multiple values)"})
    private Map<String, String> categories;
    @CommandLine.Option(names={"-b", "--contact-name"}, description={"Categories (use comma seperated list for multiple values)"})
    private String contactName;
    @CommandLine.Option(names={"-e", "--contact-email"}, description={"Categories (use comma seperated list for multiple values)"})
    private String contactEmail;
    @CommandLine.Option(names={"-P", "--properties"}, description={"Properties"})
    private Map<String, String> properties;
    @CommandLine.Option(names={"-s", "--status"}, description={"Status ( Valid values: ${COMPLETION-CANDIDATES} )"})
    private CreateExchangeAssetRequest.Status status = CreateExchangeAssetRequest.Status.PUBLISHED;
    @CommandLine.ArgGroup(exclusive=false)
    private List<AssetFile> files;

    @Override
    public Integer call() throws Exception {
        logger.info("Uploading asset to exchange");
        AnypointClient anypointClient = this.getCli().getAnypointClient();
        Object user = null;
        if (this.assetId == null) {
            throw new IllegalArgumentException("assetId not set and couldn't be automatically identified");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("version not set and couldn't be automatically identified");
        }
        CreateExchangeAssetRequest builder = anypointClient.getExchangeClient().createAsset().orgId(this.getOrgId()).groupId(this.groupId).assetId(this.assetId).version(this.version).name(this.name != null ? this.name : this.assetId).description(this.description).type(this.type).dependencies(this.dependencies).keywords(this.keywords).tags(this.tags).contactName(this.contactName).contactEmail(this.contactEmail).properties(this.properties).status(this.status);
        if (this.fields != null) {
            builder = builder.fields(this.fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet<String>(Arrays.asList(((String)e.getValue()).split(","))))));
        }
        if (this.categories != null) {
            builder = builder.categories(this.categories.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet<String>(Arrays.asList(((String)e.getValue()).split(","))))));
        }
        for (AssetFile assetFile : this.files) {
            String filename = assetFile.file.getName();
            if (assetFile.packaging == null) {
                int idx = filename.lastIndexOf(".");
                if (idx < 0) {
                    throw new IllegalArgumentException("Packaging not set and not extension found in file name");
                }
                assetFile.packaging = filename.substring(idx + 1);
            }
            if (assetFile.mimeType == null) {
                assetFile.mimeType = Files.probeContentType(assetFile.file.toPath());
            }
            if (assetFile.mimeType == null) {
                assetFile.mimeType = "application/octet-stream";
            }
            builder = builder.file(assetFile.packaging, assetFile.classifier, assetFile.mimeType, assetFile.file.getName(), assetFile.file);
        }
        builder.execute();
        logger.info("Asset uploaded successfully");
        return 0;
    }

    public static class AssetFile {
        @CommandLine.Option(names={"-f"}, description={"File path"}, required=true)
        File file;
        @CommandLine.Option(names={"-k"}, description={"File packaging"}, required=false)
        String packaging;
        @CommandLine.Option(names={"-c"}, description={"File classified"}, required=false)
        String classifier;
        @CommandLine.Option(names={"-m"}, description={"File mimeType"}, required=false)
        String mimeType;
    }
}

