/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.commons.ThreadUtils;
import com.aeontronix.commons.exception.UnexpectedException;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.authentication.AuthenticationProvider;
import com.aeontronix.enhancedmule.tools.util.AnypointAccessToken;
import com.aeontronix.enhancedmule.tools.util.EMHttpClient;
import com.aeontronix.enhancedmule.tools.util.HttpDeleteWithBody;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.aeontronix.enhancedmule.tools.util.StreamSource;
import com.aeontronix.enhancedmule.tools.util.UnauthorizedHttpException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpHelper.class);
    private static final String HEADER_AUTH = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final long TOOMANYCALLSRETRYDELAY = TimeUnit.SECONDS.toMillis(45L);
    private static String anypointPlatformUrl = "https://anypoint.mulesoft.com";
    private EMHttpClient httpClient;
    private AuthenticationProvider authenticationProvider;
    private AnypointAccessToken authToken;
    private JsonHelper jsonHelper;
    private int maxRetries = 4;
    private boolean loginRequest = false;
    private int loginAttempts = 0;
    private long retryDelay = 1000L;

    public HttpHelper() {
    }

    public HttpHelper(JsonHelper jsonHelper, AuthenticationProvider authenticationProvider) {
        this.jsonHelper = jsonHelper;
        this.httpClient = authenticationProvider.createHttpClient();
        this.authenticationProvider = authenticationProvider;
    }

    public static String getAnypointPlatformUrl() {
        return anypointPlatformUrl;
    }

    public static void setAnypointPlatformUrl(String anypointPlatformUrl) {
        HttpHelper.anypointPlatformUrl = anypointPlatformUrl;
    }

    private static void setHeader(Map<String, String> headers, HttpRequestBase method) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            method.setHeader(entry.getKey(), entry.getValue());
        }
    }

    protected static String convertPath(String path) {
        return path.startsWith("/") ? anypointPlatformUrl + path : path;
    }

    @NotNull
    private static HashMap<String, String> createOrgAndOwnerHeaders(String orgId, String ownerId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-organization-id", orgId);
        headers.put("x-owner-id", ownerId);
        return headers;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public void httpGetBasicAuth(String path, OutputStream outputStream) throws HttpException {
        logger.debug("HTTP GET W/ BASIC AUTH: " + path);
        HttpGet request = new HttpGet(HttpHelper.convertPath(path));
        this.httpExecuteMethodBasicAuth(outputStream, (HttpRequestBase)request);
    }

    public void httpPutBasicAuth(String path, InputStream is, OutputStream outputStream) throws HttpException {
        logger.debug("HTTP PUT W/ BASIC AUTH: " + path);
        HttpPut request = new HttpPut(HttpHelper.convertPath(path));
        request.setEntity((HttpEntity)new InputStreamEntity(is));
        this.httpExecuteMethodBasicAuth(outputStream, (HttpRequestBase)request);
    }

    private void httpExecuteMethodBasicAuth(OutputStream outputStream, HttpRequestBase request) throws HttpException {
        this.setBasicAuthHeader(request);
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            this.verifyStatusCode(request, response);
            if (outputStream != null) {
                if (response.getEntity() == null) {
                    throw new HttpException("Not body returned by url " + request.getURI());
                }
                IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            if (e instanceof HttpException) {
                throw (HttpException)e;
            }
            throw new HttpException(e.getMessage(), e);
        }
    }

    public String anypointHttpGet(String path, Environment env) throws HttpException {
        logger.debug("HTTP GET " + path + " env=" + env);
        return this.executeAnypointWithEnv((HttpRequestBase)new HttpGet(HttpHelper.convertPath(path)), env);
    }

    public String httpGet(String path) throws HttpException {
        logger.debug("HTTP GET " + path);
        return this.executeWrapper((HttpRequestBase)new HttpGet(HttpHelper.convertPath(path)), null);
    }

    public String httpGet(String path, Map<String, String> headers) throws HttpException {
        logger.debug("HTTP GET " + path);
        HttpGet method = new HttpGet(HttpHelper.convertPath(path));
        HttpHelper.setHeader(headers, (HttpRequestBase)method);
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    public String anypointHttpGetWithOrgAndOwner(String path, String orgId, String ownerId) throws HttpException {
        logger.debug("HTTP GET " + path);
        return this.httpGet(path, HttpHelper.createOrgAndOwnerHeaders(orgId, ownerId));
    }

    public String anypointHttpPost(String path, Object data, Environment env) throws HttpException {
        logger.debug("HTTP POST " + path + " env=" + env + " data=" + data);
        return this.executeAnypointWithDataAndEnv((HttpEntityEnclosingRequestBase)new HttpPost(HttpHelper.convertPath(path)), data, env);
    }

    public String anypointHttpPostWithOrgAndOwner(String path, Object data, String orgId, String ownerId) throws HttpException {
        return this.httpPost(path, data, HttpHelper.createOrgAndOwnerHeaders(orgId, ownerId));
    }

    public String httpPost(String path, Object data, Map<String, String> headers) throws HttpException {
        logger.debug("HTTP POST " + path + " headers=" + headers + " data=" + data);
        HttpPost method = new HttpPost(HttpHelper.convertPath(path));
        HttpHelper.setHeader(headers, (HttpRequestBase)method);
        return this.execute((HttpEntityEnclosingRequestBase)method, data);
    }

    public String httpPost(String path, Object data) throws HttpException {
        logger.debug("HTTP POST " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPost(HttpHelper.convertPath(path)), data);
    }

    public String httpPatch(String path, Object data) throws HttpException {
        logger.debug("HTTP PATCH " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPatch(HttpHelper.convertPath(path)), data);
    }

    public String httpPut(String path, Object data) throws HttpException {
        logger.debug("HTTP PUT " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPut(HttpHelper.convertPath(path)), data);
    }

    public String httpPut(String path, Map<String, String> headers, Object data) throws HttpException {
        logger.debug("HTTP PUT " + path + " data=" + data);
        HttpPut method = new HttpPut(HttpHelper.convertPath(path));
        HttpHelper.setHeader(headers, (HttpRequestBase)method);
        return this.execute((HttpEntityEnclosingRequestBase)method, data);
    }

    public String anypointHttpPut(String path, Object data, Environment environment) throws HttpException {
        logger.debug("HTTP PUT " + path);
        return this.executeAnypointWithDataAndEnv((HttpEntityEnclosingRequestBase)new HttpPut(HttpHelper.convertPath(path)), data, environment);
    }

    public String httpDelete(String path) throws HttpException {
        logger.debug("HTTP DELETE " + path);
        HttpDelete method = new HttpDelete(HttpHelper.convertPath(path));
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    public String httpHardDelete(String path) throws HttpException {
        logger.debug("HTTP DELETE " + path);
        HttpDelete method = new HttpDelete(HttpHelper.convertPath(path));
        method.addHeader("x-delete-type", "hard-delete");
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    public String httpDelete(String path, Object data) throws HttpException {
        logger.debug("HTTP DELETE " + path + " data=" + data);
        return this.execute(new HttpDeleteWithBody(HttpHelper.convertPath(path)), data);
    }

    public String anypointHttpDelete(@NotNull String path, @NotNull Environment env) throws HttpException {
        logger.debug("HTTP DELETE " + path + " env=" + env);
        return this.executeAnypointWithEnv((HttpRequestBase)new HttpDelete(HttpHelper.convertPath(path)), env);
    }

    private void addEnvironmentHeaders(@Nullable Environment environment, HttpRequestBase request) {
        if (environment != null) {
            environment.addHeaders(request);
        }
    }

    public MultiPartRequest createAnypointMultiPartPostRequest(@NotNull String url, @Nullable Environment environment) {
        HttpPost request = new HttpPost(HttpHelper.convertPath(url));
        this.addEnvironmentHeaders(environment, (HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    public MultiPartRequest createAnypointMultiPartPatchRequest(@NotNull String url, @Nullable Environment environment) {
        HttpPatch request = new HttpPatch(HttpHelper.convertPath(url));
        this.addEnvironmentHeaders(environment, (HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    public MultiPartRequest createAnypointMultiPartPutRequest(@NotNull String url, @Nullable Environment environment) {
        HttpPut request = new HttpPut(HttpHelper.convertPath(url));
        this.addEnvironmentHeaders(environment, (HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    private String execute(@NotNull HttpEntityEnclosingRequestBase method, Object data) throws HttpException {
        block9: {
            if (data != null) {
                if (data instanceof HttpEntity) {
                    method.setEntity((HttpEntity)data);
                } else if (method.getFirstHeader(CONTENT_TYPE) == null) {
                    method.setHeader(CONTENT_TYPE, "application/json");
                    method.setEntity((HttpEntity)new ByteArrayEntity(this.jsonHelper.toJson(data)));
                } else {
                    try {
                        if (data instanceof byte[]) {
                            method.setEntity((HttpEntity)new ByteArrayEntity((byte[])data));
                            break block9;
                        }
                        if (data instanceof String) {
                            method.setEntity((HttpEntity)new StringEntity((String)data));
                            break block9;
                        }
                        throw new IllegalArgumentException("Invalid data http entity object type");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnexpectedException((Throwable)e);
                    }
                }
            }
        }
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    private String executeAnypointWithDataAndEnv(@NotNull HttpEntityEnclosingRequestBase method, @NotNull Object data, @NotNull Environment env) throws HttpException {
        env.addHeaders((HttpRequestBase)method);
        return this.execute(method, data);
    }

    private String executeAnypointWithEnv(@NotNull HttpRequestBase method, @NotNull Environment env) throws HttpException {
        env.addHeaders(method);
        return this.executeWrapper(method, null);
    }

    protected String executeWrapper(@NotNull HttpRequestBase method, MultiPartRequest multiPartRequest) throws HttpException {
        return this.executeWrapper(method, multiPartRequest, 0);
    }

    private String executeWrapper(@NotNull HttpRequestBase method, MultiPartRequest multiPartRequest, int attempt) throws HttpException {
        if (this.isLoginRequest()) {
            ++this.loginAttempts;
        }
        try {
            if (multiPartRequest != null) {
                ((HttpEntityEnclosingRequestBase)method).setEntity(multiPartRequest.toEntity());
            }
            return this.doExecute(method);
        }
        catch (HttpException e) {
            logger.debug("Failed to execute http request", (Throwable)e);
            if (e.getStatusCode() == 403 || e.getStatusCode() == 401) {
                if (this.loginAttempts > 1 || !this.isRepeatable(method)) {
                    throw e;
                }
                this.updateBearerToken();
                return this.doExecute(method);
            }
            if (e.getStatusCode() >= 500) {
                if (++attempt > this.maxRetries || multiPartRequest != null && multiPartRequest.toEntity() != null && !multiPartRequest.toEntity().isRepeatable()) {
                    throw e;
                }
                if (e.getStatusCode() == 502 && this.retryDelay < TOOMANYCALLSRETRYDELAY) {
                    ThreadUtils.sleep((long)TOOMANYCALLSRETRYDELAY);
                } else {
                    ThreadUtils.sleep((long)this.retryDelay);
                }
                return this.executeWrapper(method, multiPartRequest, attempt);
            }
            throw e;
        }
    }

    private boolean isRepeatable(HttpRequestBase method) {
        if (method instanceof HttpEntityEnclosingRequestBase) {
            HttpEntity entity = ((HttpEntityEnclosingRequestBase)method).getEntity();
            return entity != null && entity.isRepeatable();
        }
        return true;
    }

    private void updateBearerToken() throws HttpException {
        this.authToken = this.authenticationProvider.getBearerToken(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private synchronized String doExecute(HttpRequestBase method) throws HttpException {
        if (this.authToken != null && method.getFirstHeader(HEADER_AUTH) == null) {
            method.setHeader(HEADER_AUTH, "bearer " + this.authToken.getAnypointAccessToken());
        }
        try (CloseableHttpResponse response = this.httpClient.execute(method);){
            this.verifyStatusCode(method, response);
            if (this.isLoginRequest()) {
                this.loginAttempts = 0;
                this.setLoginRequest(false);
            }
            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                String resStr = IOUtils.toString((InputStream)response.getEntity().getContent());
                logger.debug("RESULT CONTENT: " + this.authenticationProvider.filterSecret(resStr));
                String string2 = resStr;
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            if (!(e instanceof HttpException)) throw new RuntimeIOException(e);
            throw (HttpException)e;
        }
    }

    private void verifyStatusCode(HttpRequestBase method, CloseableHttpResponse response) throws IOException, HttpException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode > 299) {
            String errMsg = response.getEntity() != null && response.getEntity().getContent() != null ? " : " + IOUtils.toString((InputStream)response.getEntity().getContent()) : "";
            String message = "Anypoint returned status code " + statusCode + " - url: " + method.getURI() + " - err: " + errMsg;
            if (statusCode == 403) {
                throw new UnauthorizedHttpException(message, statusCode);
            }
            throw new HttpException(message, statusCode);
        }
    }

    public synchronized void setProxy(@NotNull String scheme, @NotNull String host, int port, @Nullable String username, @Nullable String password) {
        if (this.httpClient != null) {
            IOUtils.close((Object[])new Object[]{this.httpClient});
        }
        this.httpClient = this.authenticationProvider.createHttpClient(new HttpHost(host, port, scheme), username, password);
    }

    public synchronized void unsetProxy() {
        if (this.httpClient != null) {
            IOUtils.close((Object[])new Object[]{this.httpClient});
        }
        this.httpClient = this.authenticationProvider.createHttpClient();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public boolean isLoginRequest() {
        return this.loginRequest;
    }

    public void setLoginRequest(boolean loginRequest) {
        this.loginRequest = loginRequest;
    }

    private HttpRequestBase setBasicAuthHeader(HttpRequestBase request) {
        try {
            String authStr = "~~~Token~~~:" + this.authenticationProvider.getBearerToken(this).getAnypointAccessToken();
            byte[] encodedAuth = Base64.getEncoder().encode(authStr.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + new String(encodedAuth);
            request.setHeader(HEADER_AUTH, authHeader);
            return request;
        }
        catch (HttpException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] httpGetBinary(String url) throws HttpException {
        byte[] byArray;
        block9: {
            HttpGet request = new HttpGet(HttpHelper.convertPath(url));
            CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
            try {
                this.verifyStatusCode((HttpRequestBase)request, response);
                if (response.getEntity() == null) {
                    throw new HttpException("Not body returned by url " + request.getURI());
                }
                byArray = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new HttpException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return byArray;
    }

    public class MultiPartRequest {
        private LinkedHashMap<String, Object> parts = new LinkedHashMap();
        private HttpEntityEnclosingRequestBase request;

        MultiPartRequest(HttpEntityEnclosingRequestBase request) {
            this.request = request;
        }

        public MultiPartRequest addText(@NotNull String name, @NotNull String value) {
            this.parts.put(name, value);
            return this;
        }

        public MultiPartRequest addBinary(@NotNull String name, @NotNull StreamSource streamSource) {
            this.parts.put(name, streamSource);
            return this;
        }

        HttpEntity toEntity() throws HttpException {
            try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                for (Map.Entry<String, Object> e : this.parts.entrySet()) {
                    if (e.getValue() instanceof String) {
                        builder.addTextBody(e.getKey(), (String)e.getValue());
                        continue;
                    }
                    if (!(e.getValue() instanceof StreamSource)) continue;
                    builder.addBinaryBody(e.getKey(), ((StreamSource)e.getValue()).createInputStream(), ContentType.APPLICATION_OCTET_STREAM, ((StreamSource)e.getValue()).getFileName());
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new HttpException("Failed to read data to send: " + e.getMessage(), e);
            }
        }

        public String execute() throws HttpException, IOException {
            try {
                logger.debug("HTTP {}", (Object)this.request);
                return HttpHelper.this.executeWrapper((HttpRequestBase)this.request, this);
            }
            catch (RuntimeIOException e) {
                throw e.getIOException();
            }
        }
    }

    public class RuntimeIOException
    extends RuntimeException {
        RuntimeIOException(IOException ioException) {
            super(ioException.getMessage(), ioException);
        }

        @NotNull
        IOException getIOException() {
            return (IOException)this.getCause();
        }
    }
}

