/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.cli.config;

import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.config.ConfigCmd;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="key", description={"Set encryption key in configuration"})
public class ConfigSetKeyCmd
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigSetKeyCmd.class);
    @CommandLine.ParentCommand
    private ConfigCmd configCmd;
    @CommandLine.Parameters(description={"Encryption key"}, arity="1")
    private String key;

    @Override
    public Integer call() throws Exception {
        EMTCli cli = this.configCmd.getCli();
        ConfigProfile profile = cli.getActiveProfile();
        profile.setCryptoKey(this.key);
        cli.saveConfig();
        logger.info("Encryption key updated");
        return 0;
    }
}

