/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AnypointClient;
import com.aeontronix.enhancedmule.tools.authentication.AuthenticationProvider;
import com.aeontronix.enhancedmule.tools.authentication.AuthenticationProviderBearerTokenImpl;
import com.aeontronix.enhancedmule.tools.authentication.AuthenticationProviderConnectedAppsImpl;
import com.aeontronix.enhancedmule.tools.authentication.AuthenticationProviderUsernamePasswordImpl;
import com.kloudtek.util.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnypointMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAnypointMojo.class);
    private AnypointClient client;
    @Parameter(property="anypoint.username")
    protected String username;
    @Parameter(property="anypoint.password")
    protected String password;
    @Parameter(property="anypoint.client.id")
    protected String clientId;
    @Parameter(property="anypoint.client.secret")
    protected String clientSecret;
    @Parameter(property="anypoint.bearer")
    protected String bearer;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    public synchronized AnypointClient getClient() {
        if (this.client == null) {
            AuthenticationProviderBearerTokenImpl authenticationProvider;
            if (this.bearer != null) {
                authenticationProvider = new AuthenticationProviderBearerTokenImpl(this.bearer);
            } else if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
                logger.debug("Using username/password credentials: {}", (Object)this.username);
                authenticationProvider = new AuthenticationProviderUsernamePasswordImpl(this.username, this.password);
            } else if (StringUtils.isNotBlank((String)this.clientId) && StringUtils.isNotBlank((String)this.clientSecret)) {
                logger.debug("Using client credentials: {}", (Object)this.clientId);
                authenticationProvider = new AuthenticationProviderConnectedAppsImpl(this.clientId, this.clientSecret);
            } else {
                throw new IllegalArgumentException("No authentication credentials specified (username/password, client id/secret or bearer)");
            }
            this.client = new AnypointClient((AuthenticationProvider)authenticationProvider);
        }
        Proxy proxy = this.settings.getActiveProxy();
        logger.debug("Checking debug settings");
        if (proxy != null) {
            logger.debug("Using proxy: " + proxy.getProtocol() + " " + proxy.getHost() + " " + proxy.getPort());
            this.client.setProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword());
        } else {
            logger.debug("No proxy specified");
        }
        return this.client;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract void doExecute() throws Exception;
}

