/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractEnvironmentalMojo;
import com.aeontronix.enhancedmule.tools.AnypointClient;
import com.aeontronix.enhancedmule.tools.Environment;
import com.aeontronix.enhancedmule.tools.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import com.kloudtek.util.StringUtils;
import com.kloudtek.util.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractEnvironmentalMojo {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    public static final String ANYPOINT_DEPLOY_PROPERTIES = "anypoint.deploy.properties.";
    @Parameter(property="anypoint.api.provisioning.skip")
    protected boolean skipApiProvisioning;
    @Parameter(property="anypoint.deploy.skip")
    protected boolean skipDeploy;
    @Parameter(property="anypoint.deploy.file")
    protected String file;
    @Parameter(property="anypoint.deploy.filename")
    protected String filename;
    @Parameter(property="anypoint.deploy.name")
    protected String appName;
    @Parameter(property="anypoint.deploy.force")
    protected boolean force;
    @Parameter(property="anypoint.deploy.skipwait")
    protected boolean skipWait;
    @Parameter(property="anypoint.deploy.timeout")
    protected long deployTimeout = TimeUnit.MINUTES.toMillis(10L);
    @Parameter(property="anypoint.deploy.retrydelay")
    protected long deployRetryDelay = 2500L;
    @Parameter(property="anypoint.deploy.properties", required=false)
    protected Map<String, String> properties;
    @Parameter(property="anypoint.deploy.propertyfile", required=false)
    protected File propertyfile;
    @Parameter(property="anypoint.deploy.fileproperties", required=false)
    protected Map<String, String> fileProperties;
    @Parameter(property="anypoint.deploy.fileproperties.path", required=false, defaultValue="config.properties")
    protected String filePropertiesPath = "config.properties";
    @Parameter(property="anypoint.deploy.fileproperties.secure", required=false, defaultValue="false")
    protected boolean filePropertiesSecure;
    @Parameter
    protected HashMap<String, String> vars;
    @Parameter(name="target", property="anypoint.target")
    private String target;
    protected ApplicationSource source;
    @Parameter(name="muleVersionName", property="anypoint.deploy.ch.muleversion", required=false)
    private String muleVersionName;
    @Parameter(name="region", property="anypoint.deploy.ch.region", required=false)
    private String region;
    @Parameter(name="workerType", property="anypoint.deploy.ch.worker.type", required=false)
    private String workerType;
    @Parameter(name="workerCount", property="anypoint.deploy.ch.worker.count")
    private Integer workerCount;
    @Parameter(name="customlog4j", property="anypoint.deploy.ch.customlog4j")
    private boolean customlog4j;
    @Parameter(property="anypoint.deploy.mergeproperties", defaultValue="true")
    private boolean mergeExistingProperties;
    @Parameter(property="anypoint.deploy.mergeproperties.override")
    private boolean mergeExistingPropertiesOverride;
    @Parameter(property="anypoint.deploy.persistentqueue", defaultValue="false")
    private boolean persistentQueues;
    @Parameter(property="anypoint.deploy.persistentqueue.encrypted", defaultValue="false")
    private boolean persistentQueuesEncrypted;
    @Parameter(property="anypoint.deploy.objectstorev1", defaultValue="false")
    private boolean objectStoreV1;
    @Parameter(property="anypoint.deploy.extMonitoring", defaultValue="true")
    private boolean extMonitoring = true;
    @Parameter(property="anypoint.deploy.staticips", defaultValue="false")
    private boolean staticIPs;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    /*
     * Exception decompiling
     */
    protected DeploymentResult deploy(Environment environment, @NotNull APIProvisioningConfig apiProvisioningConfig, @NotNull DeploymentConfig deploymentConfig) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void findDeployProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(ANYPOINT_DEPLOY_PROPERTIES) || !StringUtils.isNotBlank((String)(key = key.substring(ANYPOINT_DEPLOY_PROPERTIES.length())))) continue;
            String value = entry.getValue().toString();
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (!this.skipDeploy) {
            if (this.project.getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven")) {
                this.project = null;
            }
            if (MavenUtils.isTemplateOrExample(this.project) && !this.force) {
                logger.warn("Project contains mule-application-template or mule-application-example, skipping deployment (use anypoint.deploy.force to force the deployment)");
                return;
            }
            if (this.appName == null) {
                this.appName = this.project.getArtifactId();
                if (StringUtils.isBlank((String)this.target)) {
                    this.appName = this.appName + "-" + this.getEnvironment().getLName();
                }
            }
            if (this.file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy file defined");
                }
                if (this.project == null) {
                    throw new MojoExecutionException("File not specified while running out of project");
                }
                this.file = MavenUtils.getProjectJar(this.project).getPath();
            }
            this.source = ApplicationSource.create((String)this.getEnvironment().getOrganization().getId(), (AnypointClient)this.getClient(), (String)this.file);
            try {
                if (this.filename == null) {
                    this.filename = this.source.getFileName();
                }
                APIProvisioningConfig apiProvisioningConfig = null;
                if (!this.skipApiProvisioning) {
                    apiProvisioningConfig = new APIProvisioningConfig();
                    if (this.vars != null) {
                        apiProvisioningConfig.setVariables(this.vars);
                    }
                    apiProvisioningConfig.init(this.getEnvironment());
                }
                DeploymentConfig deploymentConfig = new DeploymentConfig();
                if (this.propertyfile != null) {
                    if (!this.propertyfile.exists()) {
                        throw new IllegalArgumentException("Property file not found: " + this.propertyfile);
                    }
                    Properties fileProps = new Properties();
                    try (FileInputStream fis = new FileInputStream(this.propertyfile);){
                        fileProps.load(fis);
                    }
                    for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                        String key = entry.toString();
                        if (this.properties.containsKey(key)) continue;
                        this.properties.put(key, entry.getValue().toString());
                    }
                }
                deploymentConfig.setProperties(this.properties);
                deploymentConfig.setMergeExistingProperties(this.mergeExistingProperties);
                deploymentConfig.setMergeExistingPropertiesOverride(this.mergeExistingPropertiesOverride);
                deploymentConfig.setFileProperties(this.fileProperties);
                deploymentConfig.setFilePropertiesPath(this.filePropertiesPath);
                deploymentConfig.setFilePropertiesSecure(this.filePropertiesSecure);
                DeploymentResult app = this.deploy(this.getEnvironment(), apiProvisioningConfig, deploymentConfig);
                if (!this.skipWait) {
                    logger.info("Waiting for application start");
                    app.waitDeployed(this.deployTimeout, this.deployRetryDelay);
                    logger.info("Application started successfully");
                }
                logger.info("Deployment completed successfully");
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{this.source});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{this.source});
        }
    }
}

