/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractOrganizationalMojo;
import com.aeontronix.enhancedmule.tools.Organization;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.AuthenticationSelector;

@Mojo(name="prepare-exchange-publish", defaultPhase=LifecyclePhase.VALIDATE)
public class PrepareExchangePublish
extends AbstractOrganizationalMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="maven.anypoint.mulesoft.com")
    private String mavenExchangeDomain;
    @Parameter(defaultValue="false", property="anypoint.prepare.updateVersionIfSnapshot")
    private boolean updateVersionIfSnapshot;
    @Parameter(defaultValue="false")
    private boolean addDistributionManagement;
    @Parameter(defaultValue="false")
    private boolean addUserOrgsRepos;
    @Parameter(defaultValue="false", property="anypoint.prepare.skip")
    private boolean skip;

    @Override
    protected void doExecute() throws Exception {
        Organization organization = this.getOrganization();
        if (!this.skip) {
            String groupId = organization.getId();
            this.project.setGroupId(groupId);
            if (this.project.getAttachedArtifacts() != null) {
                for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                    attachedArtifact.setGroupId(groupId);
                }
            }
            if (this.project.getArtifact() != null) {
                this.project.getArtifact().setGroupId(groupId);
            }
            if (this.addDistributionManagement) {
                MavenArtifactRepository repo = new MavenArtifactRepository();
                repo.setAuthentication(new Authentication(this.username, this.password));
                repo.setId("exchange-maven-" + organization.getId());
                repo.setUrl("https://" + this.mavenExchangeDomain + "/api/v1/organizations/" + organization.getId() + "/maven");
                repo.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
                this.project.setReleaseArtifactRepository((ArtifactRepository)repo);
            }
            if (this.addUserOrgsRepos) {
                AuthenticationSelector authenticationSelector = this.session.getRepositorySession().getAuthenticationSelector();
                List orgs = this.getClient().getUser().getMemberOfOrganizations();
                if (orgs != null) {
                    for (Organization org : orgs) {
                        MavenUtils.addRepositoryUsernamePassword(authenticationSelector, "exchange-maven-" + org.getId(), this.username, this.password);
                    }
                }
            }
        }
    }
}

