/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.provisioning.AnypointDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.kloudtek.util.FileUtils;
import com.kloudtek.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

@Mojo(name="process-descriptor", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ProcessDescriptorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="anypoint.descriptor", required=false)
    private String descriptor;
    @Parameter(property="muleplugin.compat")
    private boolean mulePluginCompatibility;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ObjectMapper objectMapper = JsonHelper.createMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            Map<String, Object> anypointDescriptorJson = this.loadDescriptor();
            this.legacyConvert(anypointDescriptorJson);
            AnypointDescriptor anypointDescriptor = (AnypointDescriptor)objectMapper.convertValue(anypointDescriptorJson, AnypointDescriptor.class);
            this.processDescriptor(anypointDescriptor);
            File genResDir = new File(this.project.getBuild().getDirectory() + File.separator + "generated-resources");
            if (!genResDir.exists()) {
                FileUtils.mkdirs((File)genResDir);
            }
            Resource resource = new Resource();
            resource.setDirectory(genResDir.getPath());
            this.project.addResource(resource);
            File generateDescriptorFile = new File(genResDir, "anypoint.json");
            objectMapper.writeValue(generateDescriptorFile, (Object)anypointDescriptor);
            if (!this.mulePluginCompatibility) {
                DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "json", "anypoint-descriptor", (ArtifactHandler)new DefaultArtifactHandler("json"));
                artifact.setFile(generateDescriptorFile);
                this.project.addAttachedArtifact((Artifact)artifact);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void legacyConvert(Map<String, Object> anypointDescriptor) {
        Map api = (Map)anypointDescriptor.get("api");
        if (api != null) {
            Object access;
            HashMap client = (HashMap)api.remove("clientApp");
            if (client != null) {
                anypointDescriptor.put("client", client);
            }
            if ((access = api.remove("access")) != null) {
                if (client == null) {
                    client = new HashMap();
                    anypointDescriptor.put("client", client);
                }
                client.put("access", access);
            }
        }
    }

    private void processDescriptor(AnypointDescriptor anypointDescriptor) {
        APIDescriptor api;
        String apiName = this.project.getArtifactId();
        String version = this.project.getVersion();
        if (anypointDescriptor.getId() == null) {
            anypointDescriptor.setId(apiName);
        }
        if ((api = anypointDescriptor.getApi()) != null) {
            if (api.getAssetId() == null) {
                Dependency dep = this.findRAMLDependency();
                if (dep != null) {
                    api.setAssetId(dep.getArtifactId());
                    api.setAssetVersion(dep.getVersion());
                } else {
                    api.setAssetId(apiName + "-api");
                }
            }
            if (api.getAssetVersion() == null) {
                api.setAssetVersion(version);
            }
        }
    }

    private Dependency findRAMLDependency() {
        Dependency dependency = null;
        for (Dependency d : this.project.getDependencies()) {
            String classifier = d.getClassifier();
            if (classifier == null || !classifier.equalsIgnoreCase("raml") && !classifier.equalsIgnoreCase("oas")) continue;
            if (dependency != null) {
                this.getLog().warn((CharSequence)"Found more than one raml/oas dependencies in pom, ignoring all");
                return null;
            }
            dependency = d;
        }
        return dependency;
    }

    @NotNull
    private Map<String, Object> loadDescriptor() throws IOException {
        Map<String, Object> anypointDescriptor = null;
        if (StringUtils.isNotBlank((String)this.descriptor)) {
            File descriptorFile = new File(this.descriptor);
            anypointDescriptor = this.readFile(descriptorFile);
        } else {
            File descriptorFile = this.findAnypointFile(this.project.getBasedir());
            if (descriptorFile != null) {
                anypointDescriptor = this.readFile(descriptorFile);
            }
        }
        if (anypointDescriptor == null) {
            anypointDescriptor = new HashMap<String, Object>();
        }
        return anypointDescriptor;
    }

    private Map<String, Object> readFile(File descriptorFile) throws IOException {
        if (descriptorFile.exists()) {
            String fname = descriptorFile.getName().toLowerCase();
            Object om = fname.endsWith(".yml") || fname.endsWith(".yaml") ? new YAMLMapper() : new ObjectMapper();
            om.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            return (Map)om.readValue(descriptorFile, Map.class);
        }
        return null;
    }

    private File findAnypointFile(File basedir) {
        File file = new File(basedir, "anypoint.yml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.yaml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.json");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

