/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.ApplicationDescriptorParser;
import com.aeontronix.enhancedmule.tools.config.ConfigFile;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.EncodedKey;
import com.aeontronix.kryptotek.key.AESKey;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.Iterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractCryptoMojo
extends AbstractMojo {
    @Parameter(property="anypoint.descriptor")
    private String descriptor;
    @Parameter(property="key")
    private String key;
    @Parameter(property="org")
    private String org;
    @Parameter(property="profile")
    private String profile;
    private File anypointFile;
    protected ObjectMapper objectMapper;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.key == null) {
                ConfigProfile configProfile = ConfigFile.findConfigProfile((String)this.org, (String)this.profile);
                if (configProfile != null) {
                    this.key = configProfile.getCryptoKey();
                }
                if (this.key == null) {
                    throw new MojoExecutionException("Key must be set or exist in configuration profile");
                }
            }
            AESKey key = (AESKey)CryptoUtils.readKey(AESKey.class, (EncodedKey)new EncodedKey(this.key, EncodedKey.Format.JSON));
            if (this.descriptor != null) {
                this.anypointFile = new File(this.descriptor);
                if (!this.anypointFile.exists()) {
                    throw new MojoExecutionException("Descriptor not found found: " + this.descriptor);
                }
            } else {
                this.anypointFile = ApplicationDescriptorParser.findAnypointFile(new File("."));
                if (this.anypointFile == null) {
                    throw new MojoExecutionException("Descriptor not found found: anypoint.json, anypoint.yml or anypoint.yaml");
                }
            }
            this.objectMapper = new ObjectMapper();
            JsonNode json = this.objectMapper.readTree(this.anypointFile);
            JsonNode properties = json.get("properties");
            if (properties != null) {
                for (JsonNode property : properties) {
                    ObjectNode values;
                    if (!this.isProcessingRequired(property) || (values = (ObjectNode)property.get("values")) == null) continue;
                    this.processAndUpdate(key, values, "local");
                    this.processSubtype(key, values, "envType");
                    this.processSubtype(key, values, "env");
                }
            }
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.anypointFile, (Object)json);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void processSubtype(AESKey key, ObjectNode values, String subType) throws Exception {
        JsonNode envType = values.get(subType);
        if (envType != null) {
            Iterator it = envType.fieldNames();
            while (it.hasNext()) {
                String fieldname = (String)it.next();
                this.processAndUpdate(key, (ObjectNode)envType, fieldname);
            }
        }
    }

    private void processAndUpdate(AESKey key, ObjectNode values, String fieldName) throws Exception {
        JsonNode local = this.processValueIfNotNull(key, values.get(fieldName));
        if (local != null) {
            values.set(fieldName, local);
        }
    }

    private JsonNode processValueIfNotNull(AESKey key, JsonNode value) throws Exception {
        if (value != null) {
            return this.processValue(key, value);
        }
        return null;
    }

    protected abstract JsonNode processValue(AESKey var1, JsonNode var2) throws Exception;

    protected abstract boolean isProcessingRequired(JsonNode var1);
}

