/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.config.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.enhancedmule.tools.config.ConfigFile;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.CredentialsProvider;
import com.aeontronix.enhancedmule.tools.config.CredentialsProviderAccessTokenImpl;
import com.aeontronix.enhancedmule.tools.config.CredentialsProviderAnypointBearerToken;
import com.aeontronix.enhancedmule.tools.config.CredentialsProviderAnypointUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.config.CredentialsProviderEmptyImpl;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class EMTExtension
extends AbstractMavenLifecycleParticipant {
    public static final String PLUGINKEY = "com.aeontronix.enhanced-mule:enhanced-mule-tools-maven-plugin";
    public static final String TOKEN = "~~~Token~~~";
    public static final String ENHANCED_MULE_CLIENT = "enhancedMuleClient";
    private static final Logger logger = LoggerFactory.getLogger(EMTExtension.class);
    private EnhancedMuleClient emClient;
    private AnypointBearerTokenCredentialsProvider credentialsProvider;
    private boolean mulePluginCompatibility;
    private String enhancedMuleServerUrl;
    private String anypointBearerToken;
    private String username;
    private String password;
    private String emAccessTokenId;
    private String emAccessTokenSecret;
    private String serverId;
    private String org;

    static EnhancedMuleClient createClient(String enhancedMuleServerUrl, MavenSession session, String anypointBearerToken, String username, String password, String emAccessTokenId, String emAccessTokenSecret, String org) throws MavenExecutionException {
        EnhancedMuleClient emClient = (EnhancedMuleClient)session.getCurrentProject().getContextValue(ENHANCED_MULE_CLIENT);
        try {
            if (emClient == null) {
                ConfigProfile configProfile = ConfigFile.findConfigProfile((String)org, null);
                emClient = new EnhancedMuleClient(enhancedMuleServerUrl, configProfile);
                Proxy proxy = session.getSettings().getActiveProxy();
                if (proxy != null) {
                    emClient.setProxy(new HttpHost(proxy.getHost()), proxy.getUsername(), proxy.getPassword());
                }
                session.getCurrentProject().setContextValue(ENHANCED_MULE_CLIENT, (Object)emClient);
                logger.info("Initializing Enhanced Mule Tools");
                Object credentialsProvider = null;
                if (StringUtils.isNotBlank((String)anypointBearerToken)) {
                    logger.info("Using Bearer Token");
                    credentialsProvider = new CredentialsProviderAnypointBearerToken(anypointBearerToken);
                } else if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                    logger.info("Using Username Password: {}", (Object)username);
                    credentialsProvider = new CredentialsProviderAnypointUsernamePasswordImpl(username, password);
                } else if (StringUtils.isNotBlank((String)emAccessTokenId) && StringUtils.isNotBlank((String)emAccessTokenSecret)) {
                    logger.info("Using Access Token");
                    credentialsProvider = new CredentialsProviderAccessTokenImpl(emAccessTokenId, emAccessTokenSecret);
                } else {
                    if (configProfile != null) {
                        String accessKeyId = configProfile.getAccessKeyId();
                        String accessKeySecret = configProfile.getAccessKeySecret();
                        if (StringUtils.isNotBlank((String)accessKeyId) && StringUtils.isNotBlank((String)accessKeySecret)) {
                            logger.info("Using credentials from configuration file: {}", (Object)accessKeyId);
                            credentialsProvider = configProfile.isAnypointUPW() ? new CredentialsProviderAnypointUsernamePasswordImpl(accessKeyId, accessKeySecret) : new CredentialsProviderAccessTokenImpl(accessKeyId, accessKeySecret);
                        }
                    }
                    if (credentialsProvider == null) {
                        logger.info("No EMT credentials available");
                        credentialsProvider = new CredentialsProviderEmptyImpl();
                    }
                }
                emClient.setCredentialsLoader((CredentialsProvider)credentialsProvider);
            }
        }
        catch (IOException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        return emClient;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            this.loadProperties(session);
            this.emClient = EMTExtension.createClient(this.enhancedMuleServerUrl, session, this.anypointBearerToken, this.username, this.password, this.emAccessTokenId, this.emAccessTokenSecret, this.org);
            this.addRepositoriesAuthentication(session);
        }
        catch (Exception e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
        super.afterProjectsRead(session);
    }

    private void addRepositoriesAuthentication(MavenSession session) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        MavenProject currentProject = session.getCurrentProject();
        AuthenticationSelector authenticationSelector = session.getRepositorySession().getAuthenticationSelector();
        MavenUtils.addRepositoryUsernamePassword(authenticationSelector, this.serverId, TOKEN, new MavenUtils.SecretResolver(){

            @Override
            public String getSecret() throws Exception {
                return EMTExtension.this.emClient.getAnypointBearerToken();
            }
        });
        List remoteProjectRepositories = currentProject.getRemoteProjectRepositories();
        RemoteRepository prep = this.findRemoteRepo(remoteProjectRepositories, this.serverId);
        RemoteRepository newRepo = new RemoteRepository.Builder(prep).setId(prep.getId()).setUrl(prep.getUrl()).setSnapshotPolicy(prep.getPolicy(true)).setReleasePolicy(prep.getPolicy(false)).setRepositoryManager(prep.isRepositoryManager()).setProxy(prep.getProxy()).setMirroredRepositories(prep.getMirroredRepositories()).setContentType(prep.getContentType()).setAuthentication(authenticationSelector.getAuthentication(prep)).build();
        remoteProjectRepositories.remove(prep);
        remoteProjectRepositories.add(newRepo);
    }

    private void loadProperties(MavenSession session) {
        this.mulePluginCompatibility = Boolean.parseBoolean(this.getProperty(session, "mulePluginCompatibility", "muleplugin.compat", "false"));
        this.enhancedMuleServerUrl = this.getProperty(session, "enhancedMuleServerUrl", "enhancedmule.server.url", "https://api.enhanced-mule.com");
        this.org = this.getProperty(session, "org", "anypoint.org", null);
        this.anypointBearerToken = this.getProperty(session, "bearerToken", "anypoint.bearer", null);
        this.username = this.getProperty(session, "username", "anypoint.username", null);
        this.password = this.getProperty(session, "password", "anypoint.password", null);
        this.emAccessTokenId = this.getProperty(session, "emAccessTokenId", "emule.accesstoken.id", null);
        this.emAccessTokenSecret = this.getProperty(session, "emAccessTokenSecret", "emule.accesstoken.secret", null);
        this.serverId = this.getProperty(session, "serverId", "anypoint.serverid", "anypoint-exchange-v2");
    }

    private RemoteRepository findRemoteRepo(List<RemoteRepository> remoteArtifactRepositories, String serverId) {
        for (RemoteRepository remoteArtifactRepository : remoteArtifactRepositories) {
            if (!remoteArtifactRepository.getId().equals(serverId)) continue;
            return remoteArtifactRepository;
        }
        throw new IllegalStateException("serverId not found: " + serverId);
    }

    private String getProperty(MavenSession session, String field, String property, String defaultValue) {
        Xpp3Dom attribute;
        MavenProject currentProject = session.getCurrentProject();
        Plugin plugin = currentProject.getPlugin(PLUGINKEY);
        if (plugin == null) {
            throw new IllegalStateException("Unable to find plugin com.aeontronix.enhanced-mule:enhanced-mule-tools-maven-plugin");
        }
        Object configuration = plugin.getConfiguration();
        if (configuration instanceof Xpp3Dom && (attribute = ((Xpp3Dom)configuration).getChild(field)) != null) {
            return attribute.getValue();
        }
        Object prop = session.getUserProperties().get(property);
        if (prop != null) {
            return prop.toString();
        }
        prop = currentProject.getProperties().get(property);
        if (prop != null) {
            return prop.toString();
        }
        return defaultValue;
    }

    public class AuthenticationWrapper
    extends Authentication {
        private String bearerToken;
        private EnhancedMuleClient emClient;

        public AuthenticationWrapper(EnhancedMuleClient emClient) {
            super(EMTExtension.TOKEN, null);
            this.emClient = emClient;
        }

        public String getPassword() {
            if (this.bearerToken == null) {
                try {
                    this.bearerToken = this.emClient.getAnypointBearerToken();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.bearerToken;
        }
    }
}

