/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.ApplicationDescriptorParser;
import com.aeontronix.enhancedmule.tools.application.ApplicationEnhancer;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.unpack.UnpackException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="process-descriptor", defaultPhase=LifecyclePhase.PACKAGE)
public class ProcessDescriptorMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDescriptorMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="anypoint.descriptor", required=false)
    private String descriptor;
    @Parameter(property="anypoint.descriptor.parent", required=false)
    private String parentDescriptor;
    @Parameter(property="anypoint.descriptor.inheritNameAndDesc", required=false, defaultValue="true")
    private boolean inheritNameAndDesc;
    @Parameter(property="muleplugin.compat")
    private boolean mulePluginCompatibility;
    @Parameter(property="anypoint.descriptor.autodiscovery.excludeIgnoreBasePath")
    private boolean excludeIgnoreBasePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File generateDescriptorFile = new File(this.project.getBuild().getDirectory(), "anypoint.json");
            ApplicationDescriptor applicationDescriptor = ApplicationDescriptorParser.parseAndProcess(this.descriptor, this.project, generateDescriptorFile, true, this.inheritNameAndDesc);
            if (!this.mulePluginCompatibility) {
                DefaultArtifact descriptorArtifactor = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "json", "anypoint-descriptor", (ArtifactHandler)new DefaultArtifactHandler("json"));
                descriptorArtifactor.setFile(generateDescriptorFile);
                this.project.addAttachedArtifact((Artifact)descriptorArtifactor);
            }
            try {
                Artifact artifact = this.findAppArtifact("mule-application");
                boolean light = false;
                if (artifact == null && (artifact = this.findAppArtifact("mule-application-light-package")) != null) {
                    light = true;
                }
                if (artifact != null) {
                    File file = artifact.getFile();
                    if (file == null || !file.exists()) {
                        throw new IllegalStateException("Mule artifact not found");
                    }
                    ApplicationEnhancer.enhanceApplicationArchive((File)file, (File)generateDescriptorFile, (ApplicationDescriptor)applicationDescriptor, (boolean)light, (boolean)this.excludeIgnoreBasePath);
                } else {
                    logger.warn("No mule application attached, skipping archive enhancement");
                }
            }
            catch (UnpackException | IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Artifact findAppArtifact(String classifier) {
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            String cl = attachedArtifact.getClassifier();
            logger.info("attached artifact: " + cl + " / " + attachedArtifact.getType());
            if (!cl.equals(classifier)) continue;
            return attachedArtifact;
        }
        return null;
    }
}

