/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.FileUtils;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.IconDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.PropertyDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.portal.PortalPageDescriptor;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorParser {
    private static final String[] apiExts = new String[]{".raml", ".yml", ".yaml", ".json"};
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorParser.class);

    public static ApplicationDescriptor parseAndProcess(@Nullable String descriptor, @NotNull MavenProject project, @Nullable File writeToFile, boolean addWriteToFileToProject, boolean inheritNameAndDesc) throws IOException {
        File descriptorFile;
        ObjectMapper objectMapper = JsonHelper.createMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Map<String, Object> anypointDescriptorJson = null;
        if (StringUtils.isNotBlank((String)descriptor)) {
            descriptorFile = new File(descriptor);
            anypointDescriptorJson = ApplicationDescriptorParser.readFile(descriptorFile);
        } else {
            descriptorFile = ApplicationDescriptorParser.findAnypointFile(project.getBasedir());
            if (descriptorFile != null) {
                anypointDescriptorJson = ApplicationDescriptorParser.readFile(descriptorFile);
            }
        }
        if (anypointDescriptorJson == null) {
            anypointDescriptorJson = new HashMap<String, Object>();
        }
        ApplicationDescriptorParser.legacyConvert(anypointDescriptorJson);
        ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)objectMapper.convertValue(anypointDescriptorJson, ApplicationDescriptor.class);
        ApplicationDescriptorParser.setDefaultValues(applicationDescriptor, project, inheritNameAndDesc);
        if (writeToFile != null) {
            File parentFile = writeToFile.getParentFile();
            if (!parentFile.exists()) {
                FileUtils.mkdir((File)parentFile);
            }
            objectMapper.writeValue(writeToFile, (Object)applicationDescriptor);
            if (addWriteToFileToProject) {
                Resource resource = new Resource();
                resource.setDirectory(parentFile.getPath());
                resource.setIncludes(Collections.singletonList(writeToFile.getName()));
                project.addResource(resource);
            }
        }
        return applicationDescriptor;
    }

    private static void setDefaultValues(ApplicationDescriptor applicationDescriptor, MavenProject project, boolean inheritNameAndDesc) throws IOException {
        ClientApplicationDescriptor client;
        APIDescriptor api;
        String apiArtifactId = project.getArtifactId();
        String version = project.getVersion();
        if (applicationDescriptor.getId() == null) {
            applicationDescriptor.setId(apiArtifactId);
        }
        if (applicationDescriptor.getDescription() == null && inheritNameAndDesc && StringUtils.isNotBlank((String)project.getDescription())) {
            applicationDescriptor.setDescription(project.getDescription());
        }
        if (applicationDescriptor.getName() == null && inheritNameAndDesc) {
            applicationDescriptor.setName(project.getName());
        }
        if (applicationDescriptor.getVersion() == null) {
            applicationDescriptor.setVersion(version);
        }
        if ((api = applicationDescriptor.getApi()) != null) {
            File iconFile;
            if (api.getApiIdProperty() == null) {
                api.setApiIdProperty("anypoint.api.id");
            }
            String apiIdProperty = api.getApiIdProperty();
            HashMap properties = applicationDescriptor.getProperties();
            ApplicationDescriptorParser.getOrCreateProperty(properties, apiIdProperty, "Anypoint API identifier", false);
            ApplicationDescriptorParser.getOrCreateProperty(properties, "anypoint.platform.client_id", "Anypoint platform client id", false);
            ApplicationDescriptorParser.getOrCreateProperty(properties, "anypoint.platform.client_secret", "Anypoint platform client secret", true);
            IconDescriptor icon = api.getIcon();
            if (icon == null && (iconFile = ApplicationDescriptorParser.findIcon(project)) != null) {
                icon = new IconDescriptor(iconFile.getPath());
                api.setIcon(icon);
            }
            if (icon != null && icon.getPath() != null) {
                iconFile = new File(icon.getPath());
                if (!iconFile.exists()) {
                    throw new IOException("Unable to find icon file: " + iconFile.getPath());
                }
                Path path = iconFile.toPath();
                String mimeType = Files.probeContentType(path);
                if (StringUtils.isBlank((String)mimeType)) {
                    String fpath = path.toString().toLowerCase();
                    if (fpath.endsWith(".png")) {
                        mimeType = "image/png";
                    } else if (fpath.endsWith(".svg")) {
                        mimeType = "image/svg+xml";
                    } else if (fpath.endsWith(".gif")) {
                        mimeType = "image/gif";
                    } else if (fpath.endsWith(".jpg") || fpath.endsWith(".jpeg")) {
                        mimeType = "image/jpg";
                    }
                }
                if (!StringUtils.isNotBlank((String)mimeType)) {
                    throw new IOException("Unable to identity mime-Type of icon image, please specify mimeType in descriptor: " + icon.getPath());
                }
                icon.setMimeType(mimeType);
                icon.setContent(StringUtils.base64Encode((byte[])FileUtils.toByteArray((File)iconFile)));
                icon.setPath(null);
            }
            Dependency dep = ApplicationDescriptorParser.findRAMLDependency(project);
            if (api.getAssetId() == null) {
                api.setAssetId(dep != null ? dep.getArtifactId() : apiArtifactId + "-spec");
            }
            if (api.getDescription() == null && inheritNameAndDesc) {
                api.setDescription(applicationDescriptor.getDescription());
            }
            if (api.getAssetVersion() == null) {
                if (dep != null) {
                    api.setAssetVersion(dep.getVersion());
                } else {
                    api.setAssetVersion(version);
                }
            }
            if (api.isAssetCreate() == null || api.getAssetMainFile() == null) {
                String apiSpecFile = ApplicationDescriptorParser.findAPISpecFile(project, api.getAssetId());
                if (api.isAssetCreate() == null) {
                    api.setAssetCreate(Boolean.valueOf(apiSpecFile != null));
                }
                if (api.getAssetMainFile() == null) {
                    api.setAssetMainFile(apiSpecFile);
                }
            }
            if (api.getName() == null && inheritNameAndDesc) {
                api.setName(applicationDescriptor.getName());
            }
            if (api.getPortal() != null && api.getPortal().getPages() != null) {
                for (PortalPageDescriptor page : api.getPortal().getPages()) {
                    if (page.getContent() != null) continue;
                    try (FileInputStream fis = new FileInputStream(project.getBasedir() + File.separator + page.getPath().replace("/", File.separator));){
                        page.setPath(null);
                        page.setContent(IOUtils.toString((InputStream)fis));
                    }
                }
            }
            if (api.getAssetVersion() == null) {
                api.setAssetVersion("1.0.0");
            }
            if (api.getVersion() == null) {
                if (dep != null) {
                    if (dep.getClassifier().equalsIgnoreCase("oas")) {
                        api.setVersion(api.getAssetVersion().replaceFirst("\\.\\d\\.\\d", ".0.0"));
                    } else {
                        api.setVersion("v1");
                    }
                } else {
                    api.setVersion("v1");
                }
            }
        }
        if ((client = applicationDescriptor.getClient()) != null) {
            if (client.getClientIdProperty() == null) {
                client.setClientIdProperty("anypoint.api.client.id");
            }
            if (client.getClientSecretProperty() == null) {
                client.setClientSecretProperty("anypoint.api.client.secret");
            }
            ApplicationDescriptorParser.getOrCreateProperty(applicationDescriptor.getProperties(), "anypoint.platform.client_id", "Anypoint platform client id", false);
            ApplicationDescriptorParser.getOrCreateProperty(applicationDescriptor.getProperties(), "anypoint.platform.client_secret", "Anypoint platform client secret", true);
            ApplicationDescriptorParser.getOrCreateProperty(applicationDescriptor.getProperties(), client.getClientIdProperty(), "API Client Id", false);
            ApplicationDescriptorParser.getOrCreateProperty(applicationDescriptor.getProperties(), client.getClientSecretProperty(), "API Client Secret", true);
        }
    }

    private static PropertyDescriptor getOrCreateProperty(HashMap<String, PropertyDescriptor> properties, String id, String name, boolean secure) {
        PropertyDescriptor prop = properties.get(id);
        if (prop == null) {
            prop = new PropertyDescriptor(id, name, secure);
            properties.put(id, prop);
        }
        return prop;
    }

    private static File findIcon(MavenProject project) {
        for (String fn : Arrays.asList("icon.svg", "icon.png", "icon.jpeg", "icon.jpg", "icon.gif")) {
            File f = new File(project.getBasedir(), fn);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    @Nullable
    private static String findAPISpecFile(MavenProject project, String assetId) {
        for (Resource resource : project.getResources()) {
            File dir = new File(resource.getDirectory(), "api");
            if (!dir.exists()) continue;
            List<String> filenames = Arrays.asList("api", assetId);
            for (String apiExt : apiExts) {
                for (String filename : filenames) {
                    String apiFile = filename + apiExt;
                    if (!new File(dir, apiFile).exists()) continue;
                    return apiFile;
                }
            }
        }
        return null;
    }

    private static Dependency findRAMLDependency(MavenProject project) {
        Dependency dependency = null;
        for (Dependency d : project.getDependencies()) {
            String classifier = d.getClassifier();
            if (classifier == null || !classifier.equalsIgnoreCase("raml") && !classifier.equalsIgnoreCase("oas")) continue;
            if (dependency != null) {
                logger.warn("Found more than one raml/oas dependencies in pom, ignoring all");
                return null;
            }
            dependency = d;
        }
        return dependency;
    }

    private static void legacyConvert(Map<String, Object> anypointDescriptor) {
        Map api = (Map)anypointDescriptor.get("api");
        if (api != null) {
            Object access;
            HashMap client;
            Object addAutoDiscovery;
            Object endpointJson;
            Object endpoint = api.remove("endpoint");
            if (endpoint != null) {
                logger.warn("'endpoint' is deprecated, please use implementationUrl and/or consumerUrl instead");
                api.put("implementationUrl", endpoint);
                api.put("consumerUrl", endpoint);
            }
            if ((endpointJson = api.remove("endpointJson")) != null) {
                logger.warn("'endpointJson' is deprecated, please use consumerUrlJson instead");
                api.put("consumerUrlJson", endpointJson);
            }
            if ((addAutoDiscovery = api.remove("addAutoDescovery")) != null) {
                logger.warn("'addAutoDescovery' is deprecated, please use 'addAutoDiscovery' instead");
                api.put("addAutoDiscovery", addAutoDiscovery);
            }
            if ((client = (HashMap)api.remove("clientApp")) != null) {
                logger.warn("'clientApp' under 'api' is deprecated, please use 'client' at application descriptor level instead.");
                anypointDescriptor.put("client", client);
            }
            if ((access = api.remove("access")) != null) {
                logger.warn("'access' under 'api' is deprecated, please move it inside 'client' instead.");
                if (client == null) {
                    client = new HashMap();
                    anypointDescriptor.put("client", client);
                }
                client.put("access", access);
            }
        }
    }

    private static Map<String, Object> readFile(File descriptorFile) throws IOException {
        if (descriptorFile.exists()) {
            String fname = descriptorFile.getName().toLowerCase();
            Object om = fname.endsWith(".yml") || fname.endsWith(".yaml") ? new YAMLMapper() : new ObjectMapper();
            om.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            return (Map)om.readValue(descriptorFile, Map.class);
        }
        return null;
    }

    public static File findAnypointFile(File basedir) {
        File file = new File(basedir, "anypoint.yml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.yaml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.json");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

