/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.AbstractEnvironmentalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import com.aeontronix.enhancedmule.tools.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.application.MavenHelper;
import com.aeontronix.enhancedmule.tools.application.deploy.RTFDeploymentConfig;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.legacy.deploy.CHDeployer;
import com.aeontronix.enhancedmule.tools.legacy.deploy.DeploymentConfig;
import com.aeontronix.enhancedmule.tools.legacy.deploy.HDeployer;
import com.aeontronix.enhancedmule.tools.provisioning.ProvisioningException;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.runtime.DeploymentResult;
import com.aeontronix.enhancedmule.tools.runtime.Server;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import com.aeontronix.unpack.UnpackException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractEnvironmentalMojo {
    public static final String ANYPOINT_DEPLOY_PROPERTIES = "anypoint.deploy.properties.";
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final EMTLogger elogger = new EMTLogger(logger);
    @Parameter(property="anypoint.api.provisioning.skip")
    protected boolean skipApiProvisioning;
    @Parameter(property="anypoint.deploy.skip")
    protected boolean skipDeploy;
    @Parameter(property="anypoint.deploy.file")
    protected String file;
    @Parameter(property="anypoint.deploy.filename")
    protected String filename;
    @Parameter(property="anypoint.deploy.name")
    protected String appName;
    @Parameter(property="anypoint.deploy.force")
    protected boolean force;
    @Parameter(property="anypoint.deploy.skipwait")
    protected boolean skipWait;
    @Parameter(property="anypoint.deploy.timeout")
    protected long deployTimeout = TimeUnit.MINUTES.toMillis(10L);
    @Parameter(property="anypoint.deploy.retrydelay")
    protected long deployRetryDelay = 2500L;
    @Parameter(property="anypoint.deploy.properties", required=false)
    protected Map<String, String> properties;
    @Parameter(property="anypoint.deploy.propertyfile", required=false)
    protected File propertyfile;
    @Parameter(property="anypoint.deploy.fileproperties", required=false)
    protected Map<String, String> fileProperties;
    @Parameter(property="anypoint.deploy.fileproperties.path", required=false, defaultValue="config.properties")
    protected String filePropertiesPath = "config.properties";
    @Parameter(property="anypoint.deploy.fileproperties.secure", required=false, defaultValue="false")
    protected boolean filePropertiesSecure;
    @Parameter
    protected HashMap<String, String> vars;
    protected ApplicationSource source;
    @Parameter(property="anypoint.target")
    private String legacyTarget;
    @Parameter(name="target", property="anypoint.deploy.target")
    private String target;
    @Deprecated
    @Parameter(name="muleVersionName", property="anypoint.deploy.ch.muleversion", required=false)
    private String muleVersionName;
    @Parameter(property="anypoint.deploy.ch.runtime.version", required=false)
    private String chMuleVersionName;
    @Parameter(name="region", property="anypoint.deploy.ch.region", required=false)
    private String region;
    @Parameter(name="workerType", property="anypoint.deploy.ch.worker.type", required=false)
    private String workerType;
    @Parameter(name="workerCount", property="anypoint.deploy.ch.worker.count")
    private Integer workerCount;
    @Parameter(name="customlog4j", property="anypoint.deploy.ch.customlog4j")
    private boolean customlog4j;
    @Parameter(property="anypoint.deploy.injectEnvInfo", defaultValue="true")
    private boolean injectEnvInfo;
    @Parameter(property="anypoint.deploy.mergeproperties", defaultValue="true")
    private boolean mergeExistingProperties;
    @Parameter(property="anypoint.deploy.mergeproperties.override")
    private boolean mergeExistingPropertiesOverride;
    @Parameter(property="anypoint.deploy.persistentqueue", defaultValue="false")
    private boolean persistentQueues;
    @Parameter(property="anypoint.deploy.persistentqueue.encrypted", defaultValue="false")
    private boolean persistentQueuesEncrypted;
    @Parameter(property="anypoint.deploy.objectstorev1", defaultValue="false")
    private boolean objectStoreV1;
    @Parameter(property="anypoint.deploy.extMonitoring", defaultValue="true")
    private boolean extMonitoring = true;
    @Parameter(property="anypoint.deploy.staticips", defaultValue="false")
    private boolean staticIPs;
    @Parameter(property="anypoint.deploy.buildnumber")
    private String buildNumber;
    @Parameter(property="anypoint.deploy.rtf.cpu.reserved", defaultValue="20m")
    private String cpuReserved;
    @Parameter(property="anypoint.deploy.rtf.cpu.limit", defaultValue="1700m")
    private String cpuLimit;
    @Parameter(property="anypoint.deploy.rtf.memory.reserved", defaultValue="700Mi")
    private String memoryReserved;
    @Parameter(property="anypoint.deploy.rtf.memory.limit", defaultValue="700Mi")
    private String memoryLimit;
    @Parameter(property="anypoint.deploy.rtf.clustered", defaultValue="false")
    private boolean clustered;
    @Parameter(property="anypoint.deploy.rtf.xnodereplicas", defaultValue="false")
    private boolean enforceDeployingReplicasAcrossNodes;
    @Parameter(property="anypoint.deploy.rtf.http.inbound.publicUrl")
    private String httpInboundPublicUrl;
    @Parameter(property="anypoint.deploy.rtf.jvm.args")
    private String jvmArgs;
    @Parameter(property="anypoint.deploy.rtf.runtime.version")
    private String rtfRuntimeVersion;
    @Parameter(property="anypoint.deploy.rtf.lastmilesecurity")
    private boolean lastMileSecurity;
    @Parameter(property="anypoint.deploy.rtf.forwardSslSession")
    private boolean forwardSslSession;
    @Parameter(property="anypoint.deploy.rtf.updatestrategy", defaultValue="ROLLING")
    private RTFDeploymentConfig.DeploymentModel updateStrategy;
    @Parameter(property="anypoint.deploy.rtf.replicas", defaultValue="1")
    private int replicas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (!this.skipDeploy) {
            if (this.target == null && this.legacyTarget != null) {
                this.target = this.legacyTarget;
            }
            logger.debug("Deploy target: {}", (Object)this.target);
            if (this.chMuleVersionName == null && this.muleVersionName != null) {
                logger.warn("muleVersionName (anypoint.deploy.ch.muleversion) is deprecated, please use chMuleVersionName (anypoint.deploy.ch.runtime.version) instead");
                this.chMuleVersionName = this.muleVersionName;
            }
            if (this.project.getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven")) {
                this.project = null;
            }
            if (MavenUtils.isTemplateOrExample(this.project) && !this.force) {
                logger.warn("Project contains mule-application-template or mule-application-example, skipping deployment (use anypoint.deploy.force to force the deployment)");
                return;
            }
            if (this.file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy file defined");
                }
                if (this.project == null) {
                    throw new MojoExecutionException("File not specified while running out of project");
                }
                this.file = MavenUtils.getProjectJar(this.project).getPath();
            }
            this.source = ApplicationSource.create((String)this.getOrganization().getId(), (AnypointClient)this.getClient(), (String)this.file);
            if (this.appName == null) {
                this.appName = this.project != null ? this.project.getArtifactId() : this.source.getArtifactId();
                if (StringUtils.isBlank((String)this.target) || "cloudhub".equalsIgnoreCase(this.target)) {
                    this.appName = this.appName + "-" + this.getEnvironment().getLName();
                }
            }
            try {
                if (this.filename == null) {
                    this.filename = this.source.getFileName();
                }
                APIProvisioningConfig apiProvisioningConfig = null;
                if (!this.skipApiProvisioning) {
                    apiProvisioningConfig = new APIProvisioningConfig();
                    if (this.vars != null) {
                        apiProvisioningConfig.setVariables(this.vars);
                    }
                    try {
                        apiProvisioningConfig.setEnvironment(this.getEnvironment());
                    }
                    catch (NotFoundException e) {
                        apiProvisioningConfig.setOrganization(this.getOrganization());
                    }
                }
                DeploymentConfig deploymentConfig = new DeploymentConfig();
                deploymentConfig.setRtf(new RTFDeploymentConfig(this.cpuReserved, this.cpuLimit, this.memoryReserved, this.memoryLimit, this.clustered, this.enforceDeployingReplicasAcrossNodes, this.httpInboundPublicUrl, this.jvmArgs, this.rtfRuntimeVersion, this.lastMileSecurity, this.forwardSslSession, this.updateStrategy, this.replicas));
                if (this.propertyfile != null) {
                    if (!this.propertyfile.exists()) {
                        throw new IllegalArgumentException("Property file not found: " + this.propertyfile);
                    }
                    Properties fileProps = new Properties();
                    try (FileInputStream fis = new FileInputStream(this.propertyfile);){
                        fileProps.load(fis);
                    }
                    for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                        String key = entry.getKey().toString();
                        if (this.properties.containsKey(key)) continue;
                        this.properties.put(key, entry.getValue().toString());
                    }
                }
                if (this.injectEnvInfo) {
                    try {
                        Environment environment = this.getEnvironment();
                        this.properties.put("anypoint.env.name", environment.getName());
                        this.properties.put("anypoint.env.suffix", environment.getSuffix());
                        this.properties.put("anypoint.env.npsuffix", environment.getNPSuffix());
                        this.properties.put("anypoint.env.id", environment.getId());
                        this.properties.put("anypoint.env.type", environment.getType().name());
                    }
                    catch (NotFoundException e) {
                        logger.debug("No environment, skipping settings properties for env");
                    }
                    this.properties.put("anypoint.org.name", this.getOrganization().getName());
                    this.properties.put("anypoint.org.id", this.getOrganization().getId());
                }
                deploymentConfig.setProperties(this.properties);
                deploymentConfig.setMergeExistingProperties(this.mergeExistingProperties);
                deploymentConfig.setMergeExistingPropertiesOverride(this.mergeExistingPropertiesOverride);
                deploymentConfig.setFileProperties(this.fileProperties);
                deploymentConfig.setFilePropertiesPath(this.filePropertiesPath);
                deploymentConfig.setFilePropertiesSecure(this.filePropertiesSecure);
                DeploymentResult app = this.deploy(apiProvisioningConfig, deploymentConfig);
                if (app != null && !this.skipWait) {
                    elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Waiting for application start", new Object[0]);
                    app.waitDeployed(this.deployTimeout, this.deployRetryDelay);
                    elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Application started successfully", new Object[0]);
                }
                elogger.info(EMTLogger.Product.RUNTIME_MANAGER, "Deployment completed", new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{this.source});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{this.source});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DeploymentResult deploy(@NotNull APIProvisioningConfig apiProvisioningConfig, @NotNull DeploymentConfig deploymentConfig) throws Exception {
        if (this.buildNumber == null) {
            this.buildNumber = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now());
        }
        if (this.project != null) {
            this.findDeployProperties(this.project.getProperties());
        }
        this.findDeployProperties(this.session.getUserProperties());
        this.findDeployProperties(this.session.getSystemProperties());
        try (ApplicationSource applicationSource = ApplicationSource.create((String)this.getOrganization().getId(), (AnypointClient)this.getClient(), (String)this.file);){
            if (StringUtils.isBlank((String)this.target) || this.target.equalsIgnoreCase("cloudhub")) {
                if (this.workerCount == null) {
                    this.workerCount = 1;
                }
                try {
                    deploymentConfig.setCustomlog4j(this.customlog4j);
                    deploymentConfig.setPersistentQueues(this.persistentQueues);
                    deploymentConfig.setPersistentQueuesEncrypted(this.persistentQueuesEncrypted);
                    deploymentConfig.setObjectStoreV1(this.objectStoreV1);
                    deploymentConfig.setExtMonitoring(this.extMonitoring);
                    deploymentConfig.setStaticIPs(this.staticIPs);
                    DeploymentResult deploymentResult = new CHDeployer(this.chMuleVersionName, this.region, this.workerType, this.workerCount.intValue(), this.getEnvironment(), this.appName, applicationSource, this.filename, apiProvisioningConfig, deploymentConfig).deploy();
                    return deploymentResult;
                }
                catch (NotFoundException | ProvisioningException | IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            try {
                if (this.target.equalsIgnoreCase("exchange")) {
                    this.uploadToExchange(applicationSource);
                    DeploymentResult e = null;
                    return e;
                }
            }
            catch (NotFoundException e) {
                throw new MojoExecutionException("Target " + this.target + " not found in env " + this.getEnvironment().getName() + " in business group " + this.org);
            }
            catch (ProvisioningException | IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            Server server = this.getEnvironment().findServerByName(this.target);
            DeploymentResult deploymentResult = new HDeployer(server, this.appName, applicationSource, this.filename, apiProvisioningConfig, deploymentConfig).deploy();
            return deploymentResult;
        }
    }

    private ApplicationIdentifier uploadToExchange(ApplicationSource applicationSource) throws IOException, UnpackException, NotFoundException {
        if (this.project != null) {
            return MavenHelper.uploadToMaven((ApplicationIdentifier)new ApplicationIdentifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()), (Organization)this.getOrganization(), (ApplicationSource)applicationSource, null, (String)this.buildNumber);
        }
        return MavenHelper.uploadToMaven(null, (Organization)this.getOrganization(), (ApplicationSource)applicationSource, null, (String)this.buildNumber);
    }

    private void findDeployProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(ANYPOINT_DEPLOY_PROPERTIES) || !StringUtils.isNotBlank((String)(key = key.substring(ANYPOINT_DEPLOY_PROPERTIES.length())))) continue;
            String value = entry.getValue().toString();
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(key, value);
        }
    }
}

