/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractEnvironmentalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.api.API;
import com.aeontronix.enhancedmule.tools.api.ClientApplication;
import com.aeontronix.enhancedmule.tools.provisioning.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningConfig;
import com.aeontronix.enhancedmule.tools.provisioning.api.APIProvisioningResult;
import com.aeontronix.enhancedmule.tools.provisioning.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.util.HttpException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="provision", requiresProject=false, defaultPhase=LifecyclePhase.INSTALL)
public class ProvisionMojo
extends AbstractEnvironmentalMojo {
    @Parameter(property="anypoint.descriptor", required=false, defaultValue="${project.build.directory}/anypoint.json")
    private File file;
    @Parameter
    protected HashMap<String, String> vars;
    @Parameter(property="anypoint.api.provisioning.skip")
    protected boolean skipApiProvisioning;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="provision.propsfile", required=false)
    private File propFile;
    @Parameter(property="provision.includeplatcreds", required=false, defaultValue="true")
    private boolean includePlatformCreds = true;

    @Override
    protected void doExecute() throws Exception {
        if (!this.skipApiProvisioning) {
            Properties properties;
            block20: {
                if (!this.file.exists()) {
                    throw new IllegalArgumentException("Descriptor file doesn't exist: " + this.file.getPath());
                }
                ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.getClient().getJsonHelper().getJsonMapper().readValue(this.file, ApplicationDescriptor.class);
                APIProvisioningConfig apiProvisioningConfig = new APIProvisioningConfig();
                Environment environment = this.getEnvironment();
                if (this.vars != null) {
                    apiProvisioningConfig.setEnvironment(environment);
                    apiProvisioningConfig.setVariables(this.vars);
                }
                this.getLog().info((CharSequence)"Provisioning started");
                APIProvisioningResult result = applicationDescriptor.provision(environment, apiProvisioningConfig, null);
                this.getLog().info((CharSequence)"Provisioning complete");
                properties = new Properties();
                API api = result.getApi();
                APIDescriptor apiDescriptor = applicationDescriptor.getApi();
                if (api != null && apiDescriptor.isInjectApiId()) {
                    this.getLog().info((CharSequence)(apiDescriptor.getApiIdProperty() + "=" + api.getId()));
                    properties.put(apiDescriptor.getApiIdProperty(), api.getId());
                }
                ClientApplication clientApplication = result.getClientApplication();
                ClientApplicationDescriptor clientDescriptor = applicationDescriptor.getClient();
                if (clientApplication != null && clientDescriptor != null && clientDescriptor.isInjectClientIdSec()) {
                    this.getLog().info((CharSequence)(clientDescriptor.getClientIdProperty() + "=" + clientApplication.getClientId()));
                    properties.put(clientDescriptor.getClientIdProperty(), clientApplication.getClientId());
                    properties.put(clientDescriptor.getClientSecretProperty(), clientApplication.getClientSecret());
                }
                String envClientId = environment.getClientId();
                if (this.includePlatformCreds) {
                    this.getLog().info((CharSequence)("anypoint.platform.client_id=" + envClientId));
                    properties.put("anypoint.platform.client_id", envClientId);
                    try {
                        properties.put("anypoint.platform.client_secret", environment.getClientSecret());
                    }
                    catch (HttpException e) {
                        if (e.getStatusCode() == 401) break block20;
                        throw e;
                    }
                }
            }
            this.project.getProperties().putAll((Map<?, ?>)properties);
            if (this.propFile != null) {
                Properties props = new Properties();
                if (this.propFile.exists()) {
                    try (FileReader in = new FileReader(this.propFile);){
                        props.load(in);
                    }
                }
                props.putAll((Map<?, ?>)properties);
                try (FileWriter out = new FileWriter(this.propFile);){
                    props.store(out, "");
                }
            }
        }
    }
}

