/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.AnypointClientBuilder;
import com.aeontronix.enhancedmule.tools.EMTExtension;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class AbstractAnypointMojo
extends AbstractMojo {
    public static final String BEARER_TOKEN_PROPERTY = "anypoint.bearer";
    public static final String DEFAULT_EMSERVER_URL = "https://api.enhanced-mule.com";
    public static final String EM_CLIENT = "emClient";
    public static final String ACCESSTOKEN_ID = "accesstoken.id";
    public static final String ACCESSTOKEN_SECRET = "accesstoken.secret";
    @Parameter(property="anypoint.username")
    protected String username;
    @Parameter(property="anypoint.password")
    protected String password;
    @Parameter(property="accesstoken.id")
    protected String accessTokenId;
    @Parameter(property="accesstoken.secret")
    protected String accessTokenSecret;
    @Parameter(property="anypoint.bearer")
    protected String bearerToken;
    @Parameter(property="enhancedmule.server.url", defaultValue="https://api.enhanced-mule.com")
    protected String enhancedMuleServerUrl;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="anypoint.org")
    protected String org;
    @Parameter(property="profile")
    protected String profile;
    protected EnhancedMuleClient emClient;
    private AnypointClient client;

    public synchronized AnypointClient getClient() throws IOException {
        if (this.client == null) {
            this.client = AnypointClientBuilder.buildClient(this.emClient.getAnypointBearerToken(), this.settings);
        }
        return this.client;
    }

    public EnhancedMuleClient getEmClient() {
        return this.emClient;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.emClient = EMTExtension.createClient(this.enhancedMuleServerUrl, this.session, this.bearerToken, this.username, this.password, this.accessTokenId, this.accessTokenSecret, this.profile, this.org, this.project.getGroupId());
        }
        catch (MavenExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) throw new MojoExecutionException(cause.getMessage(), cause);
            cause = e;
            throw new MojoExecutionException(cause.getMessage(), cause);
        }
        try {
            this.doExecute();
            if (this.client == null) return;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new MojoExecutionException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                if (this.client == null) throw throwable;
                IOUtils.close((Object[])new Object[]{this.client});
                throw throwable;
            }
        }
        IOUtils.close((Object[])new Object[]{this.client});
    }

    protected abstract void doExecute() throws Exception;

    protected String getProperty(String name) {
        String property = this.session.getUserProperties().getProperty(name);
        if (property == null) {
            property = this.project.getProperties().getProperty(name);
        }
        return property;
    }

    protected Map<String, String> findPrefixProperties(Map<String, String> target, String prefix) {
        if (this.project != null) {
            target = AbstractAnypointMojo.findPrefixProperties(this.project.getProperties(), target, prefix);
        }
        target = AbstractAnypointMojo.findPrefixProperties(this.session.getUserProperties(), target, prefix);
        return target;
    }

    protected static Map<String, String> findPrefixProperties(Properties source, Map<String, String> target, String prefix) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix) || !StringUtils.isNotBlank((String)(key = key.substring(prefix.length() + 1)))) continue;
            String value = entry.getValue().toString();
            if (target == null) {
                target = new HashMap<String, String>();
            }
            target.put(key, value);
        }
        return target;
    }
}

