/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.xml.XmlUtils;
import com.aeontronix.enhancedmule.tools.ApplicationDescriptorProcessorImpl;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationEnhancer;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Mojo(name="process-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ProcessDescriptorMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDescriptorMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="anypoint.descriptor", required=false)
    private String descriptor;
    @Parameter(property="anypoint.descriptor.parent", required=false)
    private String parentDescriptor;
    @Parameter(property="anypoint.descriptor.inheritNameAndDesc", required=false, defaultValue="true")
    private boolean inheritNameAndDesc;
    @Parameter(property="muleplugin.compat")
    private boolean mulePluginCompatibility;
    @Parameter(property="anypoint.descriptor.autodiscovery.excludeIgnoreBasePath")
    private boolean excludeIgnoreBasePath;
    @Parameter(property="emt.asset.pages", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}pages")
    private File assetPagesDir;
    @Parameter(property="emt.apispecdir", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}resources${file.separator}api")
    private File apiSpecDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean apikit = this.isAPIKitUsed();
            File generateDescriptorFile = new File(this.project.getBuild().getDirectory(), "anypoint.json");
            ApplicationDescriptorProcessorImpl processor = new ApplicationDescriptorProcessorImpl(this.descriptor, this.project, this.assetPagesDir, this.apiSpecDir, apikit);
            processor.legacyConvert();
            processor.setDefaultValues(this.inheritNameAndDesc);
            processor.writeToFile(generateDescriptorFile, true);
            if (!this.mulePluginCompatibility) {
                DefaultArtifact descriptorArtifactor = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "json", "anypoint-descriptor", (ArtifactHandler)new DefaultArtifactHandler("json"));
                descriptorArtifactor.setFile(generateDescriptorFile);
                this.project.addAttachedArtifact((Artifact)descriptorArtifactor);
            }
            Artifact artifact = this.findAppArtifact("mule-application");
            boolean light = false;
            if (artifact == null && (artifact = this.findAppArtifact("mule-application-light-package")) != null) {
                light = true;
            }
            if (artifact != null) {
                File file = artifact.getFile();
                if (file == null || !file.exists()) {
                    throw new IllegalStateException("Mule artifact not found");
                }
                ApplicationEnhancer.enhanceApplicationArchive((File)file, (File)generateDescriptorFile, (ApplicationDescriptor)processor.getAnypointDescriptor(), (boolean)light, (boolean)this.excludeIgnoreBasePath);
            } else {
                logger.warn("No mule application attached, skipping archive enhancement");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isAPIKitUsed() throws IOException, SAXException {
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        File[] files = outputDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        if (files != null) {
            for (File file : files) {
                Document xmlDoc = XmlUtils.parse((File)file, (boolean)true);
                Element rootEl = xmlDoc.getDocumentElement();
                if (!"http://www.mulesoft.org/schema/mule/core".equals(rootEl.getNamespaceURI()) || !"mule".equals(rootEl.getLocalName()) || rootEl.getElementsByTagNameNS("http://www.mulesoft.org/schema/mule/mule-apikit", "config").getLength() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private Artifact findAppArtifact(String classifier) {
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            String cl = attachedArtifact.getClassifier();
            logger.info("attached artifact: " + cl + " / " + attachedArtifact.getType());
            if (!cl.equals(classifier)) continue;
            return attachedArtifact;
        }
        return null;
    }
}

