/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.commons.validation.ValidationUtils;
import com.aeontronix.enhancedmule.tools.AbstractOrganizationalMojo;
import com.aeontronix.enhancedmule.tools.ApplicationDescriptorProcessorImpl;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequest;
import com.aeontronix.enhancedmule.tools.anypoint.provisioning.ProvisioningRequestImpl;
import com.aeontronix.enhancedmule.tools.application.api.IconDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.InvalidAnypointDescriptorException;
import com.aeontronix.enhancedmule.tools.exchange.APISpecSource;
import com.aeontronix.enhancedmule.tools.exchange.ExchangeAssetDescriptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="publish-rest-asset", defaultPhase=LifecyclePhase.DEPLOY)
public class PublishRestExchangeAssetMojo
extends AbstractOrganizationalMojo {
    @Parameter(property="emt.apiSpecDir", defaultValue="src${file.separator}main${file.separator}api")
    private File apiSpecDir;
    @Parameter(property="emt.assetDescriptorFile", defaultValue="exchange-asset.json")
    private File assetDescriptorFile;
    @Parameter(property="emt.buildNumber")
    private String buildNumber;
    @Parameter(property="emt.asset.pages", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}pages")
    private File assetPagesDir;
    @Parameter(property="publishrestasset.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="emt.provisioning.deletesnapshots", defaultValue="true")
    private boolean deleteSnapshots;

    @Override
    protected void doExecute() throws Exception {
        File iconFile;
        if (this.skip) {
            return;
        }
        if (!this.apiSpecDir.exists()) {
            throw new IOException(this.apiSpecDir + " doesn't exist");
        }
        if (!this.apiSpecDir.isDirectory()) {
            throw new IOException(this.apiSpecDir + " isn't a directory");
        }
        ObjectMapper om = new ObjectMapper();
        ExchangeAssetDescriptor asset = (ExchangeAssetDescriptor)om.readValue(this.assetDescriptorFile, ExchangeAssetDescriptor.class);
        if (asset.getId() == null) {
            asset.setId(this.project.getArtifactId());
        }
        if (asset.getGroupId() == null) {
            asset.setGroupId(this.getOrganization().getId());
        }
        if (asset.getVersion() == null) {
            asset.setVersion(this.project.getVersion());
        }
        if (asset.getVersion().toLowerCase().endsWith("-snapshot")) {
            if (this.buildNumber == null) {
                this.buildNumber = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSS").format(LocalDateTime.now());
            }
            asset.setVersion(asset.getVersion() + "-" + this.buildNumber);
        }
        if (asset.getName() == null) {
            asset.setName(this.project.getName());
        }
        if (asset.getDescription() == null) {
            asset.setDescription(this.project.getDescription());
        }
        if (asset.getAssetMainFile() == null) {
            asset.setAssetMainFile(ApplicationDescriptorProcessorImpl.findAPISpecFile(asset.getId(), this.apiSpecDir));
        }
        if (asset.getApiVersion() == null) {
            String majorVersion = asset.getMajorVersion();
            if ("raml".equalsIgnoreCase(asset.getClassifier())) {
                asset.setApiVersion("v" + majorVersion);
            } else {
                asset.setApiVersion(majorVersion + ".0.0");
            }
        }
        if (asset.getIcon() == null && (iconFile = ExchangeAssetDescriptor.findIcon((File)this.project.getBasedir())) != null) {
            asset.setIcon(new IconDescriptor(iconFile.getPath()));
        }
        asset.setCreate(Boolean.valueOf(true));
        asset.findPages(this.assetPagesDir);
        ValidationUtils.validate((Object)asset, InvalidAnypointDescriptorException.class, (Class[])new Class[0]);
        final HashMap<String, File> specFiles = new HashMap<String, File>();
        this.addFile(specFiles, null, this.apiSpecDir);
        ProvisioningRequestImpl provisioningRequest = new ProvisioningRequestImpl(this.buildNumber, this.deleteSnapshots, true);
        asset.publish(this.getOrganization(), new APISpecSource(){

            public Set<String> listAPISpecFiles() throws IOException {
                return specFiles.keySet();
            }

            public void writeAPISpecFile(String name, OutputStream os) throws IOException {
                try (FileInputStream fis = new FileInputStream((File)specFiles.get(name));){
                    IOUtils.copy((InputStream)fis, (OutputStream)os);
                }
            }
        }, (ProvisioningRequest)provisioningRequest);
        asset.provision(this.getOrganization());
    }

    private void addFile(HashMap<String, File> specFiles, String path, File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                String p = f.getName();
                if (path != null) {
                    p = path + "/" + p;
                }
                this.addFile(specFiles, p, f);
            }
        } else {
            specFiles.put(path, file);
        }
    }
}

