/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.util;

import com.aeontronix.commons.StringUtils;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);

    public static File getProjectJar(MavenProject project) throws MojoExecutionException {
        Artifact artifact;
        if (logger.isDebugEnabled()) {
            logger.debug("Listing attached artifacts : " + project.getAttachedArtifacts());
        }
        if (MavenUtils.isMuleApplication(artifact = project.getArtifact())) {
            return artifact.getFile();
        }
        for (Object artifactObj : project.getAttachedArtifacts()) {
            artifact = (Artifact)artifactObj;
            if (logger.isDebugEnabled()) {
                logger.debug("Found : " + artifact.getFile() + " of classifier " + artifact.getClassifier());
            }
            if (MavenUtils.isMuleApplication(artifact)) {
                logger.debug("File is mule-application");
                return artifact.getFile();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("File is not mule-application");
        }
        for (Object artifactObj : project.getAttachedArtifacts()) {
            artifact = (Artifact)artifactObj;
            if (!artifact.getType().equals("zip") || !StringUtils.isBlank((String)artifact.getClassifier())) continue;
            return artifact.getFile();
        }
        throw new MojoExecutionException("No mule-application attached artifact found");
    }

    private static boolean isMuleApplication(Artifact artifact) {
        return artifact != null && artifact.getClassifier() != null && artifact.getClassifier().equals("mule-application");
    }

    public static boolean isTemplateOrExample(MavenProject project) {
        if (project != null) {
            for (Object artifactObj : project.getAttachedArtifacts()) {
                Artifact artifact = (Artifact)artifactObj;
                String classifier = artifact.getClassifier();
                if (classifier == null || !classifier.equals("mule-application-template") && !classifier.equals("mule-application-example")) continue;
                return true;
            }
        }
        return false;
    }

    public static void addRepositoryUsernamePassword(AuthenticationSelector authenticationSelector, String id, String username, final SecretResolver secretResolver) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class selectorClass = authenticationSelector.getClass();
        if (!selectorClass.getName().equals("org.eclipse.aether.util.repository.DefaultAuthenticationSelector")) {
            throw new IllegalStateException("Unsupported maven authentication selector:" + selectorClass.getName());
        }
        ClassLoader cl = selectorClass.getClassLoader();
        Class<?> authClass = cl.loadClass("org.eclipse.aether.repository.Authentication");
        Object authProxy = Proxy.newProxyInstance(cl, new Class[]{authClass}, new InvocationHandler(){
            public String secret;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName;
                switch (methodName = method.getName()) {
                    case "hashCode": {
                        return this.hashCode();
                    }
                    case "digest": {
                        this.loadSecret();
                        args[0].getClass().getMethod("update", String[].class).invoke(args[0], new Object[]{new String[]{"password", this.secret}});
                        return null;
                    }
                    case "fill": {
                        this.loadSecret();
                        args[0].getClass().getMethod("put", String.class, Object.class).invoke(args[0], "password", this.secret);
                        return null;
                    }
                }
                return null;
            }

            private void loadSecret() throws Exception {
                if (this.secret == null) {
                    this.secret = secretResolver.getSecret();
                }
            }
        });
        Class<?> authBuilderClass = cl.loadClass("org.eclipse.aether.util.repository.AuthenticationBuilder");
        Object authBuilder = authBuilderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        authBuilderClass.getMethod("addUsername", String.class).invoke(authBuilder, username);
        authBuilderClass.getMethod("addCustom", authClass).invoke(authBuilder, authProxy);
        Object authObj = authBuilderClass.getMethod("build", new Class[0]).invoke(authBuilder, new Object[0]);
        selectorClass.getMethod("add", String.class, authClass).invoke((Object)authenticationSelector, id, authObj);
    }

    public static interface SecretResolver {
        public String getSecret() throws Exception;
    }
}

