/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.ApplicationDescriptorProcessor;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetDescriptor;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.util.APISpecHelper;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorProcessorImpl
implements ApplicationDescriptorProcessor {
    private static final String[] apiExts = new String[]{".raml", ".yml", ".yaml", ".json"};
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorProcessorImpl.class);
    public static final String DESCRIPTION = "description";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String API_ID_PROPERTY = "apiIdProperty";
    public static final String PROPERTIES = "properties";
    public static final String ICON = "icon";
    public static final String CREATE = "create";
    public static final String ASSET_MAIN_FILE = "assetMainFile";
    public static final String PORTAL = "portal";
    public static final String PAGES = "pages";
    public static final String CONTENT = "content";
    public static final String PATH = "path";
    public static final String API_VERSION = "apiVersion";
    public static final String ASSET = "asset";
    public static final String CLIENT = "client";
    public static final String CLIENT_ID_PROPERTY = "clientIdProperty";
    public static final String CLIENT_SECRET_PROPERTY = "clientSecretProperty";
    public static final String TYPE = "type";
    public static final String API = "api";
    private final MavenProject project;
    private File assetPagesDir;
    private File apiSpecDir;
    private boolean apikit;
    private final ObjectMapper objectMapper;
    private ObjectNode applicationDescriptor;

    public ApplicationDescriptorProcessorImpl(@Nullable String descriptor, @NotNull MavenProject project, File assetPagesDir, File apiSpecDir, boolean apikit) throws IOException {
        this.project = project;
        this.assetPagesDir = assetPagesDir;
        this.apiSpecDir = apiSpecDir;
        this.apikit = apikit;
        this.objectMapper = JsonHelper.createMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        File descriptorFile = StringUtils.isNotBlank((String)descriptor) ? new File(descriptor) : ApplicationDescriptor.findAnypointFile((File)project.getBasedir());
        if (descriptorFile == null) {
            logger.warn("No anypoint.json file found, using defaults");
            this.applicationDescriptor = this.objectMapper.createObjectNode();
        } else {
            this.applicationDescriptor = ApplicationDescriptorProcessorImpl.readFile(descriptorFile);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setApplicationDescriptor(String json) throws JsonProcessingException {
        this.applicationDescriptor = (ObjectNode)this.objectMapper.readTree(json);
    }

    @Override
    public void writeToFile(File file, boolean addToProject) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            FileUtils.mkdir((File)parentFile);
        }
        this.objectMapper.writeValue(file, (Object)this.applicationDescriptor);
        if (addToProject) {
            Resource resource = new Resource();
            resource.setDirectory(parentFile.getPath());
            resource.setIncludes(Collections.singletonList(file.getName()));
            this.project.addResource(resource);
        }
    }

    @Override
    public ApplicationDescriptor getAnypointDescriptor() throws IOException {
        return (ApplicationDescriptor)this.objectMapper.readerFor(ApplicationDescriptor.class).readValue((JsonNode)this.applicationDescriptor);
    }

    @Override
    public ObjectNode getApplicationDescriptorJson() {
        return this.applicationDescriptor;
    }

    @Override
    public void setDefaultValues(boolean inheritNameAndDesc) throws IOException {
        ObjectNode client;
        ObjectNode properties;
        String artifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        if (JsonHelper.isNull((JsonNode)this.applicationDescriptor.get(ID))) {
            this.applicationDescriptor.set(ID, (JsonNode)new TextNode(artifactId));
        }
        if (JsonHelper.isNull((JsonNode)this.applicationDescriptor.get(DESCRIPTION)) && inheritNameAndDesc && StringUtils.isNotBlank((String)this.project.getDescription())) {
            this.applicationDescriptor.set(DESCRIPTION, (JsonNode)new TextNode(this.project.getDescription()));
        }
        if (JsonHelper.isNull((JsonNode)this.applicationDescriptor.get(NAME)) && inheritNameAndDesc) {
            this.applicationDescriptor.set(NAME, (JsonNode)new TextNode(this.project.getName()));
        }
        if (JsonHelper.isNull((JsonNode)this.applicationDescriptor.get(VERSION))) {
            this.applicationDescriptor.set(VERSION, (JsonNode)new TextNode(version));
        } else {
            version = this.applicationDescriptor.get(VERSION).textValue();
        }
        if (JsonHelper.isNull((JsonNode)this.applicationDescriptor.get(""))) {
            this.applicationDescriptor.set(ID, (JsonNode)new TextNode(artifactId));
        }
        if (JsonHelper.isNull((JsonNode)(properties = (ObjectNode)this.applicationDescriptor.get(PROPERTIES)))) {
            properties = this.objectMapper.createObjectNode();
            this.applicationDescriptor.set(PROPERTIES, (JsonNode)properties);
        }
        ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, "anypoint.platform.client_id", "Anypoint platform client id", false);
        ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, "anypoint.platform.client_secret", "Anypoint platform client secret", true);
        ObjectNode api = (ObjectNode)this.applicationDescriptor.get(API);
        if (JsonHelper.isNull((JsonNode)api) && this.apikit) {
            api = this.objectMapper.createObjectNode();
            this.applicationDescriptor.set(API, (JsonNode)api);
        }
        if (JsonHelper.isNotNull((JsonNode)api)) {
            JsonNode assetType;
            JsonNode assetVersion;
            JsonNode apiVersion;
            File[] files;
            ObjectNode portal;
            ArrayNode pages;
            File iconFile;
            ObjectNode icon;
            TextNode apiIdProperty = (TextNode)api.get(API_ID_PROPERTY);
            if (JsonHelper.isNull((JsonNode)apiIdProperty)) {
                apiIdProperty = new TextNode("anypoint.api.id");
                api.set(API_ID_PROPERTY, (JsonNode)apiIdProperty);
            }
            ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, apiIdProperty.textValue(), "Anypoint API identifier", false);
            ObjectNode asset = (ObjectNode)api.get(ASSET);
            if (JsonHelper.isNull((JsonNode)asset)) {
                asset = this.objectMapper.createObjectNode();
                api.set(ASSET, (JsonNode)asset);
            }
            if (JsonHelper.isNull((JsonNode)(icon = (ObjectNode)asset.get(ICON))) && (iconFile = ExchangeAssetDescriptor.findIcon((File)this.project.getBasedir())) != null && iconFile.exists()) {
                icon = this.objectMapper.createObjectNode();
                if (!iconFile.exists()) {
                    throw new IOException("Unable to find icon file: " + iconFile.getPath());
                }
                Path path = iconFile.toPath();
                String mimeType = Files.probeContentType(path);
                if (StringUtils.isBlank((String)mimeType)) {
                    String fpath = path.toString().toLowerCase();
                    if (fpath.endsWith(".png")) {
                        mimeType = "image/png";
                    } else if (fpath.endsWith(".svg")) {
                        mimeType = "image/svg+xml";
                    } else if (fpath.endsWith(".gif")) {
                        mimeType = "image/gif";
                    } else if (fpath.endsWith(".jpg") || fpath.endsWith(".jpeg")) {
                        mimeType = "image/jpg";
                    }
                }
                if (!StringUtils.isNotBlank((String)mimeType)) {
                    throw new IOException("Unable to identity mime-Type of icon image, please specify mimeType in descriptor: " + iconFile.getPath());
                }
                icon.set("mimeType", (JsonNode)new TextNode(mimeType));
                icon.set(CONTENT, (JsonNode)new TextNode(StringUtils.base64EncodeToString((byte[])FileUtils.toByteArray((File)iconFile))));
                asset.set(ICON, (JsonNode)icon);
            }
            Dependency dep = ApplicationDescriptorProcessorImpl.findRAMLDependency(this.project);
            TextNode assetId = (TextNode)asset.get(ID);
            if (JsonHelper.isNull((JsonNode)assetId)) {
                assetId = new TextNode(dep != null ? dep.getArtifactId() : artifactId + "-spec");
                asset.set(ID, (JsonNode)assetId);
            }
            if (JsonHelper.isNull((JsonNode)asset.get(DESCRIPTION)) && inheritNameAndDesc && this.applicationDescriptor.get(DESCRIPTION) != null) {
                asset.set(DESCRIPTION, this.applicationDescriptor.get(DESCRIPTION));
            }
            BooleanNode assetCreate = (BooleanNode)asset.get(CREATE);
            JsonNode assetMainFile = asset.get(ASSET_MAIN_FILE);
            if (JsonHelper.isNull((JsonNode)assetCreate) || JsonHelper.isNull((JsonNode)assetMainFile)) {
                String apiSpecFile = this.findAPISpecFile(assetId.textValue());
                if (apiSpecFile == null) {
                    apiSpecFile = this.findAPISpecFile(artifactId);
                }
                if (JsonHelper.isNull((JsonNode)assetCreate)) {
                    assetCreate = BooleanNode.valueOf((apiSpecFile != null ? 1 : 0) != 0);
                    asset.set(CREATE, (JsonNode)assetCreate);
                }
                if (assetCreate.asBoolean() && JsonHelper.isNull((JsonNode)assetMainFile) && apiSpecFile != null) {
                    assetMainFile = new TextNode(apiSpecFile);
                    asset.set(ASSET_MAIN_FILE, assetMainFile);
                }
            }
            boolean restAPI = JsonHelper.isNotNull((JsonNode)assetMainFile) || dep != null;
            boolean raml = JsonHelper.isNotNull((JsonNode)assetMainFile) && assetMainFile.textValue().toLowerCase().endsWith(".raml");
            APISpecHelper.APISpecVersion apiSpecVersion = null;
            if (JsonHelper.isNotNull((JsonNode)assetMainFile)) {
                File apiSpecFile = new File(this.apiSpecDir, assetMainFile.textValue());
                apiSpecVersion = APISpecHelper.findVersion((File)apiSpecFile);
            }
            if (JsonHelper.isNull((JsonNode)asset.get(NAME)) && inheritNameAndDesc) {
                asset.set(NAME, this.applicationDescriptor.get(NAME));
            }
            ArrayNode arrayNode = pages = (portal = (ObjectNode)asset.get(PORTAL)) != null ? (ArrayNode)portal.get(PAGES) : null;
            if (JsonHelper.isNotNull((JsonNode)pages)) {
                for (File[] page : pages) {
                    JsonNode pagePath;
                    if (page.get(CONTENT) != null || (pagePath = page.get(PATH)) == null) continue;
                    try (FileInputStream fis = new FileInputStream(this.project.getBasedir() + File.separator + pagePath.textValue().replace("/", File.separator));){
                        ((ObjectNode)page).remove(PATH);
                        ((ObjectNode)page).set(CONTENT, (JsonNode)new TextNode(IOUtils.toString((InputStream)fis)));
                    }
                }
            }
            if (this.assetPagesDir != null && this.assetPagesDir.exists() && (files = this.assetPagesDir.listFiles()) != null && files.length > 0) {
                if (portal == null) {
                    portal = this.objectMapper.createObjectNode();
                    asset.set(PORTAL, (JsonNode)portal);
                }
                if (pages == null) {
                    pages = this.objectMapper.createArrayNode();
                    portal.set(PAGES, (JsonNode)pages);
                }
                for (File file : files) {
                    String fileName;
                    int idx;
                    if (!file.isFile() || (idx = (fileName = file.getName()).indexOf(".")) == -1) continue;
                    ObjectNode p = this.objectMapper.createObjectNode();
                    p.set(CONTENT, (JsonNode)new TextNode(FileUtils.toString((File)file)));
                    p.set(NAME, (JsonNode)new TextNode(fileName.substring(0, idx)));
                    pages.add((JsonNode)p);
                }
            }
            if (JsonHelper.isNull((JsonNode)(apiVersion = asset.get(API_VERSION)))) {
                String assetAPIVersion = null;
                if (dep != null) {
                    ZipFile zipFile;
                    ZipEntry entry;
                    File depFile = this.findDependencyFile(dep);
                    if (depFile != null && depFile.exists() && (entry = (zipFile = new ZipFile(depFile)).getEntry("exchange.json")) != null) {
                        JsonNode exchangeJson;
                        try (InputStream inputStream = zipFile.getInputStream(entry);){
                            exchangeJson = this.objectMapper.readTree(IOUtils.toString((InputStream)inputStream));
                        }
                        JsonNode depAPIVersion = exchangeJson.get(API_VERSION);
                        if (depAPIVersion != null && !depAPIVersion.isNull()) {
                            assetAPIVersion = depAPIVersion.textValue();
                        }
                    }
                    if (assetAPIVersion == null) {
                        assetAPIVersion = dep.getVersion();
                    }
                } else if (apiSpecVersion != null) {
                    assetAPIVersion = apiSpecVersion.getNonSnapshotVersion();
                }
                if (assetAPIVersion == null) {
                    assetAPIVersion = version != null ? version : "1.0.0";
                }
                apiVersion = new TextNode(assetAPIVersion);
                asset.set(API_VERSION, apiVersion);
            }
            if (JsonHelper.isNull((JsonNode)(assetVersion = asset.get(VERSION)))) {
                assetVersion = dep != null ? new TextNode(dep.getVersion()) : new TextNode(version);
                asset.set(VERSION, assetVersion);
            }
            if (JsonHelper.isNull((JsonNode)(assetType = asset.get(TYPE))) && restAPI) {
                assetType = new TextNode("rest");
                asset.set(TYPE, assetType);
            }
        }
        if (JsonHelper.isNotNull((JsonNode)(client = (ObjectNode)this.applicationDescriptor.get(CLIENT)))) {
            JsonNode clientSecretProperty;
            JsonNode clientIdProperty = client.get(CLIENT_ID_PROPERTY);
            if (JsonHelper.isNull((JsonNode)clientIdProperty)) {
                clientIdProperty = new TextNode("anypoint.api.client.id");
                client.set(CLIENT_ID_PROPERTY, clientIdProperty);
            }
            if (JsonHelper.isNull((JsonNode)(clientSecretProperty = client.get(CLIENT_SECRET_PROPERTY)))) {
                clientSecretProperty = new TextNode("anypoint.api.client.secret");
                client.set(CLIENT_SECRET_PROPERTY, clientSecretProperty);
            }
            ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, "anypoint.platform.client_id", "Anypoint platform client id", false);
            ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, "anypoint.platform.client_secret", "Anypoint platform client secret", true);
            ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, clientIdProperty.textValue(), "API Client Id", false);
            ApplicationDescriptorProcessorImpl.getOrCreateProperty(this.objectMapper, properties, clientSecretProperty.textValue(), "API Client Secret", true);
        }
    }

    private File findDependencyFile(Dependency dep) {
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getArtifactId().equals(dep.getArtifactId()) || !artifact.getGroupId().equals(dep.getGroupId()) || !artifact.getVersion().equals(dep.getVersion())) continue;
                return artifact.getFile();
            }
        }
        return null;
    }

    private static ObjectNode getOrCreateProperty(ObjectMapper objectMapper, ObjectNode properties, String id, String name, boolean secure) {
        ObjectNode prop = (ObjectNode)properties.get(id);
        if (prop == null) {
            prop = objectMapper.createObjectNode();
            prop.set(ID, (JsonNode)new TextNode(id));
            prop.set(NAME, (JsonNode)new TextNode(name));
            prop.set("secure", (JsonNode)BooleanNode.valueOf((boolean)secure));
            properties.set(id, (JsonNode)prop);
        }
        return prop;
    }

    @Nullable
    private String findAPISpecFile(String assetId) {
        String apiFile;
        if (this.apiSpecDir != null && this.apiSpecDir.exists() && (apiFile = ApplicationDescriptorProcessorImpl.findAPISpecFile(assetId, this.apiSpecDir)) != null) {
            return apiFile;
        }
        return null;
    }

    @Nullable
    public static String findAPISpecFile(String assetId, File dir) {
        if (dir.exists()) {
            List<String> filenames = Arrays.asList(API, assetId);
            for (String apiExt : apiExts) {
                for (String filename : filenames) {
                    String apiFile = filename + apiExt;
                    if (!new File(dir, apiFile).exists()) continue;
                    return apiFile;
                }
            }
        }
        return null;
    }

    private static Dependency findRAMLDependency(MavenProject project) {
        Dependency dependency = null;
        for (Dependency d : project.getDependencies()) {
            String classifier = d.getClassifier();
            if (classifier == null || !classifier.equalsIgnoreCase("raml") && !classifier.equalsIgnoreCase("oas") && !classifier.equalsIgnoreCase("wsdl")) continue;
            if (dependency != null) {
                logger.warn("Found more than one raml/oas dependencies in pom, ignoring all");
                return null;
            }
            dependency = d;
        }
        return dependency;
    }

    @Override
    public void legacyConvert() {
        ObjectNode api = (ObjectNode)this.applicationDescriptor.get(API);
        if (api != null) {
            JsonNode access;
            ObjectNode client;
            JsonNode addAutoDiscovery;
            JsonNode endpointJson;
            JsonNode endpoint;
            JsonNode assetCreate;
            JsonNode assetMainFile;
            JsonNode description;
            JsonNode version;
            JsonNode assetId = api.remove("assetId");
            JsonNode assetVersion = api.remove("assetVersion");
            ObjectNode asset = (ObjectNode)api.get(ASSET);
            if (asset == null) {
                asset = this.objectMapper.createObjectNode();
                api.set(ASSET, (JsonNode)asset);
            }
            if (assetId != null || assetVersion != null) {
                logger.warn("api->assetId and api->assetVersion are deprecated, use api->asset->id and api->asset->version instead");
                asset.set(ID, assetId);
                asset.set(VERSION, assetVersion);
            }
            ApplicationDescriptorProcessorImpl.relocate(api, "exchangeTags", "api->exchangeTags", asset, "tags", "api->asset->tags");
            JsonNode name = ApplicationDescriptorProcessorImpl.relocate(api, NAME, "api->name", asset, NAME, "api->asset->name");
            ApplicationDescriptorProcessorImpl.relocate(api, CREATE, "api->create", asset, CREATE, "api->asset->create");
            ApplicationDescriptorProcessorImpl.relocate(api, TYPE, "api->type", asset, TYPE, "api->asset->type");
            JsonNode apiVersion = api.remove(API_VERSION);
            if (apiVersion != null && api.get(VERSION) == null) {
                logger.warn("'api->apiVersion' is deprecated, use api->asset->apiVersion instead");
                asset.set(API_VERSION, apiVersion);
            }
            if ((version = api.remove(VERSION)) != null) {
                asset.set(API_VERSION, name);
                logger.warn("api->version deprecated, use api->asset->apiVersion instead");
            }
            if ((description = api.remove(DESCRIPTION)) != null) {
                asset.set(DESCRIPTION, description);
                logger.warn("api->description deprecated, use api->asset->description instead");
            }
            if ((assetMainFile = api.remove(ASSET_MAIN_FILE)) != null) {
                asset.set(ASSET_MAIN_FILE, description);
                logger.warn("api->assetMainFile deprecated, use api->asset->assetMainFile instead");
            }
            if ((assetCreate = api.remove("assetCreate")) != null) {
                asset.set(CREATE, assetCreate);
                logger.warn("api->assetCreate deprecated, use api->asset->create instead");
            }
            if ((endpoint = api.remove("endpoint")) != null) {
                logger.warn("'endpoint' is deprecated, please use implementationUrl and/or consumerUrl instead");
                api.set("implementationUrl", endpoint);
                api.set("consumerUrl", endpoint);
            }
            if ((endpointJson = api.remove("endpointJson")) != null) {
                logger.warn("'endpointJson' is deprecated, please use consumerUrlJson instead");
                api.set("consumerUrlJson", endpointJson);
            }
            if ((addAutoDiscovery = api.remove("addAutoDescovery")) != null) {
                logger.warn("'addAutoDescovery' is deprecated, please use 'addAutoDiscovery' instead");
                api.set("addAutoDiscovery", addAutoDiscovery);
            }
            if ((client = (ObjectNode)api.remove("clientApp")) != null) {
                logger.warn("'clientApp' under 'api' is deprecated, please use 'client' at application descriptor level instead.");
                this.applicationDescriptor.set(CLIENT, (JsonNode)client);
            }
            if ((access = api.remove("access")) != null) {
                logger.warn("'access' under 'api' is deprecated, please move it inside 'client' instead.");
                if (client == null) {
                    client = this.objectMapper.createObjectNode();
                    this.applicationDescriptor.set(CLIENT, (JsonNode)client);
                }
                client.set("access", access);
            }
            ApplicationDescriptorProcessorImpl.relocate(asset, "assetId", "asset->assetId", asset, ID, "asset->id");
            if (client == null) {
                client = (ObjectNode)this.applicationDescriptor.get(CLIENT);
            }
            if (client != null && (access = client.get("access")) != null) {
                for (JsonNode jsonNode : access) {
                    JsonNode envId = jsonNode.get("envId");
                    if (envId == null) continue;
                    logger.warn("client->access->envId is deprecated, use client->access->env instead");
                    ((ObjectNode)jsonNode).set("env", envId);
                }
            }
        }
    }

    private static JsonNode relocate(ObjectNode oldParent, String oldName, String oldLocationTxt, ObjectNode newParent, String newName, String newLocationTxt) {
        JsonNode node = oldParent.remove(oldName);
        if (node != null) {
            newParent.set(newName, node);
            logger.warn(oldLocationTxt + " is deprecated, use " + newLocationTxt + " instead");
        }
        return node;
    }

    private static ObjectNode readFile(File descriptorFile) throws IOException {
        if (descriptorFile.exists()) {
            String fname = descriptorFile.getName().toLowerCase();
            Object om = fname.endsWith(".yml") || fname.endsWith(".yaml") ? new YAMLMapper() : new ObjectMapper();
            om.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            return (ObjectNode)om.readTree(descriptorFile);
        }
        return null;
    }
}

