/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.AnypointClientBuilder;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.config.ConfigCredentials;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.EMConfig;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProvider;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderAnypointBearerToken;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderAnypointUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderClientCredentialsImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderEmptyImpl;
import com.aeontronix.enhancedmule.tools.util.CredentialsConverter;
import com.aeontronix.kryptotek.DigestUtils;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.auth.BearerTokenAuthenticationHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnypointMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAnypointMojo.class);
    public static final String BEARER_TOKEN_PROPERTY = "anypoint.bearer";
    public static final String DEFAULT_EMSERVER_URL = "https://api.enhanced-mule.com";
    public static final String EM_CLIENT = "emClient";
    public static final String EM_CLIENT_ID = "anypoint.client.id";
    public static final String EM_CLIENT_SECRET = "anypoint.client.secret";
    public static final String ANYPOINT_USERNAME = "anypoint.username";
    public static final String ANYPOINT_PASSWORD = "anypoint.password";
    @Parameter(property="anypoint.username")
    protected String username;
    @Parameter(property="anypoint.password")
    protected String password;
    @Parameter(property="anypoint.client.id")
    protected String clientId;
    @Parameter(property="anypoint.client.secret")
    protected String clientSecret;
    @Parameter(property="anypoint.bearer")
    protected String bearerToken;
    @Parameter(property="enhancedmule.server.url", defaultValue="https://api.enhanced-mule.com")
    protected String enhancedMuleServerUrl;
    @Parameter(property="anypoint.url")
    protected String anypointPlatformUrl;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="anypoint.org")
    protected String org;
    @Parameter(property="profile")
    protected String profile;
    protected EnhancedMuleClient emClient;
    private LegacyAnypointClient legacyClient;
    private EMConfig emConfig;
    protected ConfigProfile configProfile;
    protected AnypointClient anypointClient;

    public synchronized LegacyAnypointClient getLegacyClient() throws IOException, ProfileNotFoundException {
        return this.legacyClient;
    }

    public EnhancedMuleClient getEmClient() {
        return this.emClient;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating client");
                logger.debug("Server URL: {}", (Object)this.enhancedMuleServerUrl);
                logger.debug("Anypoint URL: {}", (Object)this.anypointPlatformUrl);
                logger.debug("Bearer: SHA:{}", (Object)(this.bearerToken != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.bearerToken.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
                logger.debug("Username: {}", (Object)(this.username != null ? this.username : "NOT SET"));
                logger.debug("Password: SHA:{}", (Object)(this.password != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.password.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
                logger.debug("Client Id: {}", (Object)(this.clientId != null ? this.clientId : "NOT SET"));
                logger.debug("Client Secret: SHA:{}", (Object)(this.clientSecret != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.clientSecret.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
            }
            this.emConfig = EMConfig.findConfigFile();
            this.configProfile = this.emConfig.getProfile(this.profile);
            logger.info("Using profile: " + (this.profile != null ? this.profile : this.emConfig.getActive()));
            if (this.anypointPlatformUrl == null) {
                this.anypointPlatformUrl = this.configProfile.getAnypointUrl() != null ? this.configProfile.getAnypointUrl() : "https://anypoint.mulesoft.com";
            }
            logger.info("Anypoint server: {}", (Object)this.anypointPlatformUrl);
            Proxy proxy = this.session.getSettings().getActiveProxy();
            CredentialsProviderAnypointBearerToken credentialsProvider = null;
            if (StringUtils.isNotBlank((String)this.bearerToken)) {
                logger.info("Using Bearer Token");
                credentialsProvider = new CredentialsProviderAnypointBearerToken(this.bearerToken);
            } else if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
                logger.info("Using Username Password: {}", (Object)this.username);
                credentialsProvider = new CredentialsProviderAnypointUsernamePasswordImpl(this.username, this.password);
            } else if (StringUtils.isNotBlank((String)this.clientId) && StringUtils.isNotBlank((String)this.clientSecret)) {
                logger.info("Using Client Credentials: {}", (Object)this.clientId);
                credentialsProvider = new CredentialsProviderClientCredentialsImpl(this.clientId, this.clientSecret);
            } else if (this.configProfile != null && this.configProfile.getCredentials() != null) {
                credentialsProvider = CredentialsConverter.convert((ConfigCredentials)this.configProfile.getCredentials());
            }
            if (credentialsProvider == null) {
                logger.info("No EMT credentials available");
                credentialsProvider = new CredentialsProviderEmptyImpl();
            }
            EnhancedMuleClient.Builder emClientBuilder = EnhancedMuleClient.builder((CredentialsProvider)credentialsProvider).serverUrl(this.enhancedMuleServerUrl).anypointUrl(this.anypointPlatformUrl);
            ProxySettings proxySettings = null;
            if (proxy != null) {
                proxySettings = new ProxySettings(URI.create(proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort()), proxy.getUsername(), proxy.getPassword(), null);
                emClientBuilder.proxySettings(proxySettings);
            }
            this.emClient = emClientBuilder.build();
            this.legacyClient = AnypointClientBuilder.buildClient(this.emClient.getAnypointBearerToken(), this.settings, this.anypointPlatformUrl);
            this.anypointClient = AnypointClient.builder().authenticationHandler((AuthenticationHandler)new BearerTokenAuthenticationHandler(this.emClient.getAnypointBearerToken())).proxy(proxySettings).anypointUrl(this.anypointPlatformUrl).build();
            logger.info("Initializing Enhanced Mule Tools");
        }
        catch (ProfileNotFoundException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            this.doExecute();
            if (this.legacyClient == null) return;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new MojoExecutionException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                if (this.legacyClient == null) throw throwable;
                IOUtils.close((Object[])new Object[]{this.legacyClient});
                throw throwable;
            }
        }
        IOUtils.close((Object[])new Object[]{this.legacyClient});
    }

    protected abstract void doExecute() throws Exception;

    protected String getProperty(String name) {
        String property = this.session.getUserProperties().getProperty(name);
        if (property == null) {
            property = this.project.getProperties().getProperty(name);
        }
        return property;
    }

    protected Map<String, String> findPrefixProperties(Map<String, String> target, String prefix) {
        if (this.project != null) {
            target = AbstractAnypointMojo.findPrefixProperties(this.project.getProperties(), target, prefix);
        }
        target = AbstractAnypointMojo.findPrefixProperties(this.session.getUserProperties(), target, prefix);
        return target;
    }

    protected static Map<String, String> findPrefixProperties(Properties source, Map<String, String> target, String prefix) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix) || !StringUtils.isNotBlank((String)(key = key.substring(prefix.length())))) continue;
            String value = entry.getValue().toString();
            if (target == null) {
                target = new HashMap<String, String>();
            }
            target.put(key, value);
        }
        return target;
    }
}

