/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.LegacyDeployMojo;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentServiceImpl;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DescriptorLayers;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.ExchangeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RuntimeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.EMTProperties;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends LegacyDeployMojo {
    public static final String ANYPOINT_DEPLOY_PROPERTIES = "anypoint.deploy.properties.";
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final EMTLogger emtLogger = new EMTLogger(logger);
    public static final String VAR = "emt.var";
    public static final String CLOUDHUB = "cloudhub";
    public static final String EMT_TARGET = "emt.target";
    public static final String EMT_SECUREPROPERTIES = "emt.secureproperties";
    public static final String SECURE_PREFIX = "emt.secureproperties.";
    @Parameter(property="emt.skipProvisioning")
    protected boolean skipProvisioning;
    @Parameter(property="anypoint.deploy.skip")
    protected boolean skipDeploy;
    @Parameter(property="anypoint.deploy.file")
    protected String file;
    @Parameter(property="anypoint.deploy.filename")
    protected String filename;
    @Parameter(property="anypoint.deploy.properties", required=false)
    protected Map<String, String> appProperties;
    @Parameter(property="anypoint.deploy.propertyfile", required=false)
    protected File propertyfile;
    @Parameter(property="anypoint.deploy.propertyfile.ignoremissing", required=false)
    protected boolean ignoreMissingPropertyFile;
    @Parameter(property="anypoint.deploy.fileproperties", required=false)
    protected Map<String, String> fileProperties;
    @Parameter(property="anypoint.deploy.fileproperties.path", required=false, defaultValue="config.properties")
    protected String filePropertiesPath = "config.properties";
    @Parameter(property="anypoint.deploy.fileproperties.secure", required=false, defaultValue="false")
    protected boolean filePropertiesSecure;
    @Parameter
    protected Map<String, String> vars;
    @Parameter(property="anypoint.deploy.buildnumber")
    private String buildNumber;
    @Parameter(property="emt.provisioning.deletesnapshots")
    private Boolean deleteSnapshots;
    @Parameter(property="emt.target")
    private String target;
    @Deprecated
    @Parameter(property="anypoint.api.provisioning.skip")
    protected boolean skipApiProvisioning;

    @Override
    protected void doExecute() throws Exception {
        if (!this.skipDeploy) {
            EMTProperties emtProperties = this.getEMTProperties();
            this.handleDeprecated();
            if (this.project.getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven")) {
                this.project = null;
            }
            if (MavenUtils.isTemplateOrExample(this.project) && !this.force) {
                logger.warn("Project contains mule-application-template or mule-application-example, skipping deployment (use anypoint.deploy.force to force the deployment)");
                return;
            }
            if (this.file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy file defined");
                }
                if (this.project == null) {
                    throw new MojoExecutionException("File not specified while running out of project");
                }
                this.file = MavenUtils.getProjectJar(this.project).getPath();
            }
            ApplicationIdentifier applicationIdentifier = this.project != null ? new ApplicationIdentifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()) : null;
            DeploymentServiceImpl deploymentService = new DeploymentServiceImpl(this.getOrganization().getClient(), this.anypointClient);
            try (ApplicationSource source = ApplicationSource.create((String)this.getOrganization().getId(), (LegacyAnypointClient)this.getLegacyClient(), (String)this.file);){
                if (this.target != null && this.target.equalsIgnoreCase("exchange")) {
                    ExchangeDeploymentRequest req = new ExchangeDeploymentRequest(this.buildNumber, applicationIdentifier, this.getOrganization(), source, null);
                    ApplicationIdentifier appId = deploymentService.deployToExchange(req);
                    emtLogger.info(EMTLogger.Product.EXCHANGE, "Published application to exchange: " + appId.getGroupId() + ":" + appId.getArtifactId() + ":" + appId.getVersion(), new Object[0]);
                } else {
                    this.vars = this.findPrefixedProperties(VAR);
                    this.appProperties = this.findPrefixedProperties(ANYPOINT_DEPLOY_PROPERTIES);
                    HashSet<String> secureProperties = new HashSet<String>();
                    for (Map.Entry e : emtProperties.getProperties().entrySet()) {
                        if (!((String)e.getKey()).startsWith(SECURE_PREFIX) || !"true".equalsIgnoreCase((String)e.getValue())) continue;
                        secureProperties.add(((String)e.getKey()).substring(SECURE_PREFIX.length()));
                    }
                    JsonNode deploymentParametersOverridesLegacy = this.getDeploymentParametersOverrides();
                    RuntimeDeploymentRequest request = new RuntimeDeploymentRequest(this.filename != null ? this.filename : source.getFileName(), this.appName, source.getArtifactId(), this.buildNumber, this.vars, this.appProperties, this.propertyfile, this.ignoreMissingPropertyFile, this.target, this.getEnvironment(), this.injectEnvInfo.booleanValue(), this.skipWait, this.skipProvisioning, deploymentParametersOverridesLegacy);
                    request.addSecureProperties(secureProperties);
                    request.setFileProperties(this.fileProperties);
                    request.setFilePropertiesPath(this.filePropertiesPath);
                    request.setFilePropertiesSecure(this.filePropertiesSecure);
                    request.setDeleteSnapshots(this.deleteSnapshots != null && this.deleteSnapshots != false);
                    ObjectNode appDescJson = source.getAnypointDescriptor();
                    deploymentService.deploy(request, appDescJson, new DescriptorLayers(emtProperties), source);
                }
            }
        }
    }

    private void handleDeprecated() {
        if (this.legacyTarget1 != null) {
            logger.warn("Property 'anypoint.deploy.target' is deprecated, please use emt.target");
            if (this.target != null) {
                this.target = this.legacyTarget1;
            }
        }
        if (this.legacyTarget2 != null) {
            logger.warn("Property 'anypoint.target' is deprecated, please use emt.target");
            this.target = this.legacyTarget2;
            if (this.target != null) {
                this.target = this.legacyTarget2;
            }
        }
        if (this.chMuleVersionName == null && this.muleVersionName != null) {
            logger.warn("muleVersionName (anypoint.deploy.ch.muleversion) is deprecated, please use chMuleVersionName (anypoint.deploy.ch.runtime.version) instead");
            this.chMuleVersionName = this.muleVersionName;
        }
        if (this.skipApiProvisioning && !this.skipProvisioning) {
            this.skipProvisioning = true;
        }
    }
}

