/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractEnvironmentalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RTFDeploymentConfig;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.deployment.CloudhubDeploymentParameters;
import com.aeontronix.enhancedmule.tools.application.deployment.DeploymentParameters;
import com.aeontronix.enhancedmule.tools.application.deployment.RTFDeploymentParameters;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Duration;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class LegacyDeployMojo
extends AbstractEnvironmentalMojo {
    @Parameter(property="anypoint.deploy.name.chsuffix")
    protected String appNameCHSuffix;
    @Parameter(property="anypoint.deploy.name.chsuffixnponly")
    protected boolean appNameCHSuffixNPOnly;
    @Parameter(property="anypoint.deploy.name.chprefix")
    protected String appNameCHPrefix;
    @Parameter(property="anypoint.deploy.force")
    protected boolean force;
    @Parameter(property="anypoint.deploy.skipwait")
    protected boolean skipWait;
    @Parameter(property="anypoint.deploy.timeout")
    protected Long deployTimeout;
    @Parameter(property="anypoint.deploy.retrydelay")
    protected Long deployRetryDelay;
    @Parameter(property="anypoint.deploy.name")
    protected String appName;
    @Parameter(name="legacyTarget1", property="anypoint.deploy.target")
    protected String legacyTarget1;
    @Parameter(name="legacyTarget2", property="anypoint.target")
    protected String legacyTarget2;
    @Deprecated
    @Parameter(name="muleVersionName", property="anypoint.deploy.ch.muleversion", required=false)
    protected String muleVersionName;
    @Parameter(property="anypoint.deploy.ch.runtime.version", required=false)
    protected String chMuleVersionName;
    @Parameter(name="region", property="anypoint.deploy.ch.region", required=false)
    protected String region;
    @Parameter(name="workerType", property="anypoint.deploy.ch.worker.type", required=false)
    protected String workerType;
    @Parameter(name="workerCount", property="anypoint.deploy.ch.worker.count")
    protected Integer workerCount;
    @Parameter(name="customlog4j", property="anypoint.deploy.ch.customlog4j")
    protected Boolean customlog4j;
    @Parameter(property="anypoint.deploy.injectEnvInfo", defaultValue="true")
    protected Boolean injectEnvInfo;
    @Parameter(property="anypoint.deploy.mergeproperties", defaultValue="true")
    protected Boolean mergeExistingProperties;
    @Parameter(property="anypoint.deploy.mergeproperties.override")
    protected Boolean mergeExistingPropertiesOverride;
    @Parameter(property="anypoint.deploy.persistentqueue", defaultValue="false")
    protected Boolean persistentQueues;
    @Parameter(property="anypoint.deploy.persistentqueue.encrypted", defaultValue="false")
    protected Boolean persistentQueuesEncrypted;
    @Parameter(property="anypoint.deploy.objectstorev1", defaultValue="false")
    protected Boolean objectStoreV1;
    @Parameter(property="anypoint.deploy.extMonitoring", defaultValue="true")
    protected Boolean extMonitoring;
    @Parameter(property="anypoint.deploy.staticips", defaultValue="false")
    protected Boolean staticIPs;
    @Parameter(property="anypoint.deploy.rtf.cpu.reserved")
    protected String cpuReserved;
    @Parameter(property="anypoint.deploy.rtf.cpu.limit")
    protected String cpuLimit;
    @Parameter(property="anypoint.deploy.rtf.memory.reserved")
    protected String memoryReserved;
    @Parameter(property="anypoint.deploy.rtf.memory.limit")
    protected String memoryLimit;
    @Parameter(property="anypoint.deploy.rtf.clustered")
    protected Boolean clustered;
    @Parameter(property="anypoint.deploy.rtf.xnodereplicas")
    protected Boolean enforceDeployingReplicasAcrossNodes;
    @Parameter(property="anypoint.deploy.rtf.http.inbound.publicUrl")
    protected String httpInboundPublicUrl;
    @Parameter(property="anypoint.deploy.rtf.jvm.args")
    protected String jvmArgs;
    @Parameter(property="anypoint.deploy.rtf.runtime.version")
    protected String rtfRuntimeVersion;
    @Parameter(property="anypoint.deploy.rtf.lastmilesecurity")
    protected Boolean lastMileSecurity;
    @Parameter(property="anypoint.deploy.rtf.forwardSslSession")
    protected Boolean forwardSslSession;
    @Parameter(property="anypoint.deploy.rtf.updatestrategy")
    protected RTFDeploymentConfig.DeploymentModel updateStrategy;
    @Parameter(property="anypoint.deploy.rtf.replicas")
    protected Integer replicas;

    public JsonNode getDeploymentParametersOverrides() throws IOException, ProfileNotFoundException {
        ApplicationDescriptor app = new ApplicationDescriptor();
        DeploymentParameters deploymentParameters = new DeploymentParameters();
        app.setDeploymentParams(deploymentParameters);
        if (this.legacyTarget1 != null) {
            deploymentParameters.setTarget(this.legacyTarget1);
        } else if (this.legacyTarget2 != null) {
            deploymentParameters.setTarget(this.legacyTarget2);
        }
        deploymentParameters.setDeployTimeout(this.deployTimeout != null ? Duration.ofMillis(this.deployTimeout) : null);
        deploymentParameters.setDeployRetryDelay(this.deployRetryDelay != null ? Duration.ofMillis(this.deployRetryDelay) : null);
        deploymentParameters.setMergeExistingProperties(this.mergeExistingProperties);
        deploymentParameters.setMergeExistingPropertiesOverride(this.mergeExistingPropertiesOverride);
        deploymentParameters.setMergeExistingPropertiesOverride(this.mergeExistingPropertiesOverride);
        deploymentParameters.setExtMonitoring(this.extMonitoring);
        CloudhubDeploymentParameters ch = deploymentParameters.getCloudhub();
        ch.setAppNamePrefix(this.appNameCHPrefix);
        ch.setAppNameSuffixNPOnly(Boolean.valueOf(this.appNameCHSuffixNPOnly));
        ch.setAppNameSuffix(this.appNameCHSuffix);
        ch.setMuleVersion(this.chMuleVersionName);
        ch.setPersistentQueues(this.persistentQueues);
        ch.setPersistentQueuesEncrypted(this.persistentQueuesEncrypted);
        ch.setObjectStoreV1(this.objectStoreV1);
        ch.setCustomlog4j(this.customlog4j);
        ch.setStaticIPs(this.staticIPs);
        ch.setRegion(this.region);
        ch.setWorkerType(this.workerType);
        ch.setWorkerCount(this.workerCount);
        RTFDeploymentParameters rtf = deploymentParameters.getRtf();
        rtf.setCpuReserved(this.cpuReserved);
        rtf.setCpuLimit(this.cpuLimit);
        rtf.setMemoryReserved(this.memoryReserved);
        rtf.setMemoryLimit(this.memoryLimit);
        rtf.setClustered(this.clustered);
        rtf.setEnforceDeployingReplicasAcrossNodes(this.enforceDeployingReplicasAcrossNodes);
        rtf.setHttpInboundPublicUrl(this.httpInboundPublicUrl);
        rtf.setJvmArgs(this.jvmArgs);
        rtf.setRuntimeVersion(this.rtfRuntimeVersion);
        rtf.setLastMileSecurity(this.lastMileSecurity);
        rtf.setForwardSslSession(this.forwardSslSession);
        rtf.setUpdateStrategy(this.updateStrategy);
        rtf.setReplicas(this.replicas);
        app.getDeploymentParams().setCloudhub2(null);
        return this.getLegacyClient().getJsonHelper().getJsonMapper().valueToTree((Object)app);
    }
}

