/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.anypointsdk.AnypointClient;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.AnypointClientBuilder;
import com.aeontronix.enhancedmule.tools.AuthType;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.config.ConfigCredentials;
import com.aeontronix.enhancedmule.tools.config.ConfigProfile;
import com.aeontronix.enhancedmule.tools.config.EMConfig;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.aeontronix.enhancedmule.tools.emclient.EnhancedMuleClient;
import com.aeontronix.enhancedmule.tools.emclient.authentication.AnypointBearerTokenCredentialsProvider;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderAnypointBearerToken;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderAnypointUsernamePasswordImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderClientCredentialsImpl;
import com.aeontronix.enhancedmule.tools.emclient.authentication.CredentialsProviderEmptyImpl;
import com.aeontronix.enhancedmule.tools.util.CredentialsConverter;
import com.aeontronix.enhancedmule.tools.util.EMTProperties;
import com.aeontronix.kryptotek.DigestUtils;
import com.aeontronix.restclient.ProxySettings;
import com.aeontronix.restclient.auth.AuthenticationHandler;
import com.aeontronix.restclient.auth.BearerTokenAuthenticationHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnypointMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAnypointMojo.class);
    public static final String BEARER_TOKEN_PROPERTY = "anypoint.bearer";
    public static final String DEFAULT_EMSERVER_URL = "https://api.enhanced-mule.com";
    public static final String EM_CLIENT = "emClient";
    @Parameter
    protected String authType;
    @Parameter
    protected String username;
    @Parameter
    protected String password;
    @Parameter
    protected String clientId;
    @Parameter
    protected String clientSecret;
    @Parameter(property="anypoint.bearer")
    protected String bearerToken;
    @Parameter(property="enhancedmule.server.url", defaultValue="https://api.enhanced-mule.com")
    protected String enhancedMuleServerUrl;
    @Parameter(property="anypoint.url")
    protected String anypointPlatformUrl;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="anypoint.org")
    protected String org;
    @Parameter(property="profile")
    protected String profile;
    protected EnhancedMuleClient emClient;
    private LegacyAnypointClient legacyClient;
    private EMConfig emConfig;
    protected ConfigProfile configProfile;
    protected AnypointClient anypointClient;
    private AuthType authTypeEnum;

    public synchronized LegacyAnypointClient getLegacyClient() throws IOException, ProfileNotFoundException {
        return this.legacyClient;
    }

    public EnhancedMuleClient getEmClient() {
        return this.emClient;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            AnypointBearerTokenCredentialsProvider credentialsProvider;
            Proxy proxy;
            block18: {
                block17: {
                    this.initFields();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Creating client");
                        logger.debug("Server URL: {}", (Object)this.enhancedMuleServerUrl);
                        logger.debug("Anypoint URL: {}", (Object)this.anypointPlatformUrl);
                        logger.debug("Bearer: SHA:{}", (Object)(this.bearerToken != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.bearerToken.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
                        logger.debug("Username: {}", (Object)(this.username != null ? this.username : "NOT SET"));
                        logger.debug("Password: SHA:{}", (Object)(this.password != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.password.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
                        logger.debug("Client Id: {}", (Object)(this.clientId != null ? this.clientId : "NOT SET"));
                        logger.debug("Client Secret: SHA:{}", (Object)(this.clientSecret != null ? StringUtils.base64EncodeToString((byte[])DigestUtils.sha512((byte[])this.clientSecret.getBytes(StandardCharsets.UTF_8))) : "NOT SET"));
                        logger.debug("Auth Type: {}", this.authTypeEnum != null ? this.authTypeEnum : "NOT SET");
                    }
                    this.emConfig = EMConfig.findConfigFile();
                    this.configProfile = this.emConfig.getProfile(this.profile);
                    logger.info("Using profile: " + (this.profile != null ? this.profile : this.emConfig.getActive()));
                    if (this.anypointPlatformUrl == null) {
                        this.anypointPlatformUrl = this.configProfile.getAnypointUrl() != null ? this.configProfile.getAnypointUrl() : "https://anypoint.mulesoft.com";
                    }
                    logger.info("Anypoint server: {}", (Object)this.anypointPlatformUrl);
                    proxy = this.session.getSettings().getActiveProxy();
                    credentialsProvider = null;
                    if (this.authTypeEnum == null) break block17;
                    switch (this.authTypeEnum) {
                        case BEARER: {
                            logger.info("Using Bearer Token");
                            credentialsProvider = new CredentialsProviderAnypointBearerToken(this.bearerToken);
                            break block18;
                        }
                        case CLIENTCREDS: {
                            logger.info("Using Client Credentials: {}", (Object)this.clientId);
                            credentialsProvider = new CredentialsProviderClientCredentialsImpl(this.clientId, this.clientSecret);
                            break block18;
                        }
                        case UPW: {
                            logger.info("Using Username Password: {}", (Object)this.username);
                            credentialsProvider = new CredentialsProviderAnypointUsernamePasswordImpl(this.username, this.password);
                            break block18;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid auth type enum: " + (Object)((Object)this.authTypeEnum));
                        }
                    }
                }
                if (this.configProfile != null && this.configProfile.getCredentials() != null) {
                    credentialsProvider = CredentialsConverter.convert((ConfigCredentials)this.configProfile.getCredentials());
                }
            }
            if (credentialsProvider == null) {
                logger.info("No EMT credentials available");
                credentialsProvider = new CredentialsProviderEmptyImpl();
            }
            EnhancedMuleClient.Builder emClientBuilder = EnhancedMuleClient.builder(credentialsProvider).serverUrl(this.enhancedMuleServerUrl).anypointUrl(this.anypointPlatformUrl);
            ProxySettings proxySettings = null;
            if (proxy != null) {
                proxySettings = new ProxySettings(URI.create(proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort()), proxy.getUsername(), proxy.getPassword(), null);
                emClientBuilder.proxySettings(proxySettings);
            }
            this.emClient = emClientBuilder.build();
            this.legacyClient = AnypointClientBuilder.buildClient(this.emClient.getAnypointBearerToken(), this.settings, this.anypointPlatformUrl);
            this.anypointClient = AnypointClient.builder().authenticationHandler((AuthenticationHandler)new BearerTokenAuthenticationHandler(this.emClient.getAnypointBearerToken())).proxy(proxySettings).anypointUrl(this.anypointPlatformUrl).build();
            logger.info("Initializing Enhanced Mule Tools");
        }
        catch (ProfileNotFoundException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            this.doExecute();
            if (this.legacyClient == null) return;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new MojoExecutionException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                if (this.legacyClient == null) throw throwable;
                IOUtils.close((Object[])new Object[]{this.legacyClient});
                throw throwable;
            }
        }
        IOUtils.close((Object[])new Object[]{this.legacyClient});
    }

    private void initFields() {
        this.clientId = this.getMavenProperty("emt.auth.client.id", this.clientId, "anypoint.client.id");
        this.clientSecret = this.getMavenProperty("emt.auth.client.secret", this.clientSecret, "anypoint.client.secret");
        this.username = this.getMavenProperty("emt.auth.username", this.username, "anypoint.username");
        this.password = this.getMavenProperty("emt.auth.password", this.password, "anypoint.password");
        this.authType = this.getMavenProperty("emt.auth.type", this.authType, new String[0]);
        if (StringUtils.isNotBlank((String)this.authType)) {
            try {
                this.authTypeEnum = AuthType.valueOf(this.authType.toUpperCase());
                switch (this.authTypeEnum) {
                    case UPW: {
                        if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) break;
                        throw new IllegalArgumentException("Auth type upw specified but username and password aren't both set");
                    }
                    case CLIENTCREDS: {
                        if (!StringUtils.isBlank((String)this.clientId) && !StringUtils.isBlank((String)this.clientSecret)) break;
                        throw new IllegalArgumentException("Auth type upw specified but clientId and clientSecret aren't both set");
                    }
                    case BEARER: {
                        if (!StringUtils.isBlank((String)this.bearerToken)) break;
                        throw new IllegalArgumentException("Auth type upw specified but bearerToken is not set");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Auth type value is invalid, must be one of " + Arrays.toString((Object[])AuthType.values()));
            }
        } else {
            this.authTypeEnum = StringUtils.isNotBlank((String)this.bearerToken) ? AuthType.BEARER : (StringUtils.isNotBlank((String)this.clientId) && StringUtils.isNotBlank((String)this.clientSecret) ? AuthType.CLIENTCREDS : (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password) ? AuthType.UPW : null));
        }
    }

    protected abstract void doExecute() throws Exception;

    protected String getProperty(String name) {
        String property = this.session.getUserProperties().getProperty(name);
        if (property == null) {
            property = this.project.getProperties().getProperty(name);
        }
        return property;
    }

    public Map<String, String> getMavenProperties() {
        final HashMap<String, String> results = new HashMap<String, String>();
        BiConsumer<Object, Object> converter = new BiConsumer<Object, Object>(){

            @Override
            public void accept(Object key, Object val) {
                results.put(String.valueOf(key), String.valueOf(val));
            }
        };
        this.project.getProperties().forEach((BiConsumer<? super Object, ? super Object>)converter);
        this.session.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)converter);
        return results;
    }

    public Boolean getMavenProperty(String key, @Nullable Boolean defValue, String ... legacyKeys) {
        String result = this.getMavenProperty(key, defValue != null ? defValue.toString() : null, legacyKeys);
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getMavenProperty(String key, @Nullable String defValue, String ... legacyKeys) {
        return EMTProperties.getProperty(this.getMavenProperties(), (String)key, (String)defValue, (String[])legacyKeys);
    }

    public EMTProperties getEMTProperties() throws NotFoundException, IOException, ProfileNotFoundException {
        return new EMTProperties(this.getMavenProperties(), null, null, null);
    }

    @NotNull
    protected Map<String, String> findPrefixedProperties(String ... prefixes) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (String prefix : prefixes) {
            if (this.project != null) {
                results.putAll(AbstractAnypointMojo.findPrefixedProperties(this.project.getProperties(), prefix));
            }
            results.putAll(AbstractAnypointMojo.findPrefixedProperties(this.session.getUserProperties(), prefix));
        }
        return results;
    }

    protected static Map<String, String> findPrefixedProperties(Properties source, String prefix) {
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix) || !StringUtils.isNotBlank((String)(key = key.substring(prefix.length())))) continue;
            String value = entry.getValue().toString();
            results.put(key, value);
        }
        return results;
    }
}

