/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.file.FileUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.enhancedmule.tools.ApplicationDescriptorProcessor;
import com.aeontronix.enhancedmule.tools.anypoint.exchange.ExchangeAssetDescriptor;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.APIDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.ClientApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.IconDescriptor;
import com.aeontronix.enhancedmule.tools.application.api.PropertyDescriptor;
import com.aeontronix.enhancedmule.tools.application.portal.PortalPageDescriptor;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ApplicationDescriptorLegacyProcessor
implements ApplicationDescriptorProcessor {
    private static final String[] apiExts = new String[]{".raml", ".yml", ".yaml", ".json"};
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorLegacyProcessor.class);
    private final MavenProject project;
    private File assetPagesDir;
    private boolean inheritNameAndDesc;
    private Map<String, Object> anypointDescriptorJson;
    private final ObjectMapper objectMapper;
    private ApplicationDescriptor applicationDescriptor;

    public ApplicationDescriptorLegacyProcessor(@Nullable String descriptor, @NotNull MavenProject project, File assetPagesDir) throws IOException {
        this.project = project;
        this.assetPagesDir = assetPagesDir;
        this.objectMapper = JsonHelper.createMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.anypointDescriptorJson = null;
        if (StringUtils.isNotBlank((String)descriptor)) {
            File descriptorFile = new File(descriptor);
            this.anypointDescriptorJson = ApplicationDescriptorLegacyProcessor.readFile(descriptorFile);
        } else {
            File descriptorFile = ApplicationDescriptorLegacyProcessor.findAnypointFile(project.getBasedir());
            if (descriptorFile != null) {
                this.anypointDescriptorJson = ApplicationDescriptorLegacyProcessor.readFile(descriptorFile);
            }
        }
        if (this.anypointDescriptorJson == null) {
            this.anypointDescriptorJson = new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getAnypointDescriptorJson() {
        return this.anypointDescriptorJson;
    }

    @Override
    public void writeToFile(File file, boolean addToProject) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            FileUtils.mkdir((File)parentFile);
        }
        this.objectMapper.writeValue(file, this.anypointDescriptorJson);
        if (addToProject) {
            Resource resource = new Resource();
            resource.setDirectory(parentFile.getPath());
            resource.setIncludes(Collections.singletonList(file.getName()));
            this.project.addResource(resource);
        }
    }

    @Override
    public void setDefaultValues(boolean inheritNameAndDesc) throws IOException {
        ClientApplicationDescriptor client;
        APIDescriptor api;
        this.applicationDescriptor = (ApplicationDescriptor)this.objectMapper.convertValue(this.anypointDescriptorJson, ApplicationDescriptor.class);
        String apiArtifactId = this.project.getArtifactId();
        String version = this.project.getVersion();
        if (this.applicationDescriptor.getId() == null) {
            this.applicationDescriptor.setId(apiArtifactId);
        }
        if (this.applicationDescriptor.getDescription() == null && inheritNameAndDesc && StringUtils.isNotBlank((String)this.project.getDescription())) {
            this.applicationDescriptor.setDescription(this.project.getDescription());
        }
        if (this.applicationDescriptor.getName() == null && inheritNameAndDesc) {
            this.applicationDescriptor.setName(this.project.getName());
        }
        if (this.applicationDescriptor.getVersion() == null) {
            this.applicationDescriptor.setVersion(version);
        }
        if ((api = this.applicationDescriptor.getApi()) != null) {
            File iconFile;
            ExchangeAssetDescriptor asset = api.getAsset();
            if (asset == null) {
                asset = new ExchangeAssetDescriptor();
                api.setAsset(asset);
            }
            if (api.getApiIdProperty() == null) {
                api.setApiIdProperty("anypoint.api.id");
            }
            String apiIdProperty = api.getApiIdProperty();
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            this.getOrCreateProperty(properties, apiIdProperty, "Anypoint API identifier", false);
            this.getOrCreateProperty(properties, "anypoint.platform.client_id", "Anypoint platform client id", false);
            this.getOrCreateProperty(properties, "anypoint.platform.client_secret", "Anypoint platform client secret", true);
            IconDescriptor icon = asset.getIcon();
            if (icon == null && (iconFile = ExchangeAssetDescriptor.findIcon((File)this.project.getBasedir())) != null) {
                icon = new IconDescriptor(iconFile.getPath());
                asset.setIcon(icon);
            }
            Dependency dep = ApplicationDescriptorLegacyProcessor.findRAMLDependency(this.project);
            if (asset.getId() == null) {
                asset.setId(dep != null ? dep.getArtifactId() : apiArtifactId + "-spec");
            }
            if (asset.getDescription() == null && inheritNameAndDesc) {
                asset.setDescription(this.applicationDescriptor.getDescription());
            }
            if (api.getAssetVersion() == null) {
                if (dep != null) {
                    api.setAssetVersion(dep.getVersion());
                } else {
                    api.setAssetVersion(version);
                }
            }
            if (asset.getCreate() == null || asset.getAssetMainFile() == null) {
                String apiSpecFile = this.findAPISpecFile(this.project, asset.getId());
                if (asset.getCreate() == null) {
                    asset.setCreate(Boolean.valueOf(apiSpecFile != null));
                }
                if (asset.getAssetMainFile() == null) {
                    asset.setAssetMainFile(apiSpecFile);
                }
            }
            if (asset.getName() == null && inheritNameAndDesc) {
                asset.setName(this.applicationDescriptor.getName());
            }
            if (asset.getPortal() != null && asset.getPortal().getPages() != null) {
                for (PortalPageDescriptor page : asset.getPortal().getPages()) {
                    if (page.getContent() != null) continue;
                    try (FileInputStream fis = new FileInputStream(this.project.getBasedir() + File.separator + page.getPath().replace("/", File.separator));){
                        page.setPath(null);
                        page.setContent(IOUtils.toString((InputStream)fis));
                    }
                }
            }
            if (asset.getVersion() == null) {
                asset.setVersion("1.0.0");
            }
            if (asset.getApiVersion() == null) {
                if (dep != null) {
                    String majorVersion = ExchangeAssetDescriptor.getMajorVersion((String)dep.getVersion());
                    if (dep.getClassifier().equalsIgnoreCase("oas")) {
                        asset.setApiVersion(majorVersion + ".0.0");
                    } else {
                        asset.setApiVersion("v" + majorVersion);
                    }
                } else {
                    asset.setApiVersion("v" + asset.getMajorVersion());
                }
            }
        }
        if ((client = this.applicationDescriptor.getClient()) != null) {
            if (client.getClientIdProperty() == null) {
                client.setClientIdProperty("anypoint.api.client.id");
            }
            if (client.getClientSecretProperty() == null) {
                client.setClientSecretProperty("anypoint.api.client.secret");
            }
        }
    }

    @Override
    public ApplicationDescriptor getAnypointDescriptor() {
        return this.applicationDescriptor;
    }

    @Override
    public ObjectNode getApplicationDescriptorJson() {
        return (ObjectNode)this.objectMapper.valueToTree((Object)this.applicationDescriptor);
    }

    private PropertyDescriptor getOrCreateProperty(HashMap<String, PropertyDescriptor> properties, String id, String name, boolean secure) {
        PropertyDescriptor prop = properties.get(id);
        if (prop == null) {
            prop = new PropertyDescriptor(id, name, secure);
            properties.put(id, prop);
        }
        return prop;
    }

    @Nullable
    private String findAPISpecFile(MavenProject project, String assetId) {
        for (Resource resource : project.getResources()) {
            File dir = new File(resource.getDirectory(), "api");
            String apiFile = ApplicationDescriptorLegacyProcessor.findAPISpecFile(assetId, dir);
            if (apiFile == null) continue;
            return apiFile;
        }
        return null;
    }

    @Nullable
    public static String findAPISpecFile(String assetId, File dir) {
        if (dir.exists()) {
            List<String> filenames = Arrays.asList("api", assetId);
            for (String apiExt : apiExts) {
                for (String filename : filenames) {
                    String apiFile = filename + apiExt;
                    if (!new File(dir, apiFile).exists()) continue;
                    return apiFile;
                }
            }
        }
        return null;
    }

    private static Dependency findRAMLDependency(MavenProject project) {
        Dependency dependency = null;
        for (Dependency d : project.getDependencies()) {
            String classifier = d.getClassifier();
            if (classifier == null || !classifier.equalsIgnoreCase("raml") && !classifier.equalsIgnoreCase("oas")) continue;
            if (dependency != null) {
                logger.warn("Found more than one raml/oas dependencies in pom, ignoring all");
                return null;
            }
            dependency = d;
        }
        return dependency;
    }

    @Override
    public void legacyConvert() {
        Map api = (Map)this.anypointDescriptorJson.get("api");
        if (api != null) {
            Object access;
            HashMap client;
            Object addAutoDiscovery;
            Object endpointJson;
            Object endpoint;
            Object assetCreate;
            Object assetMainFile;
            Object description;
            Object version;
            Object apiVersion;
            Object type;
            Object create;
            Object name;
            Object exchangeTags;
            Object assetId = api.remove("assetId");
            Object assetVersion = api.remove("assetVersion");
            HashMap asset = (HashMap)api.get("asset");
            if (asset == null) {
                asset = new HashMap();
                api.put("asset", asset);
            }
            if (assetId != null || assetVersion != null) {
                logger.warn("api->assetId and api->assetVersion are deprecated, use api->asset->id and api->asset->version instead");
                asset.put("id", assetId);
                asset.put("version", assetVersion);
            }
            if ((exchangeTags = api.remove("exchangeTags")) != null) {
                asset.put("tags", exchangeTags);
                logger.warn("api->exchangeTags is deprecated, use api->asset->tags instead");
            }
            if ((name = api.remove("name")) != null) {
                asset.put("name", name);
                logger.warn("api->name deprecated, use api->asset->name instead");
            }
            if ((create = api.remove("create")) != null) {
                asset.put("create", name);
                logger.warn("api->create deprecated, use api->asset->create instead");
            }
            if ((type = api.remove("type")) != null) {
                asset.put("type", name);
                logger.warn("api->type deprecated, use api->asset->type instead");
            }
            if ((apiVersion = api.remove("apiVersion")) != null && api.get("version") == null) {
                logger.warn("'api->apiVersion' is deprecated, use api->asset->apiVersion instead");
                asset.put("apiVersion", apiVersion);
            }
            if ((version = api.remove("version")) != null) {
                asset.put("apiVersion", name);
                logger.warn("api->version deprecated, use api->asset->apiVersion instead");
            }
            if ((description = api.remove("description")) != null) {
                asset.put("description", description);
                logger.warn("api->description deprecated, use api->asset->description instead");
            }
            if ((assetMainFile = api.remove("assetMainFile")) != null) {
                asset.put("assetMainFile", description);
                logger.warn("api->assetMainFile deprecated, use api->asset->assetMainFile instead");
            }
            if ((assetCreate = api.remove("assetCreate")) != null) {
                asset.put("create", assetCreate);
                logger.warn("api->assetCreate deprecated, use api->asset->create instead");
            }
            if ((endpoint = api.remove("endpoint")) != null) {
                logger.warn("'endpoint' is deprecated, please use implementationUrl and/or consumerUrl instead");
                api.put("implementationUrl", endpoint);
                api.put("consumerUrl", endpoint);
            }
            if ((endpointJson = api.remove("endpointJson")) != null) {
                logger.warn("'endpointJson' is deprecated, please use consumerUrlJson instead");
                api.put("consumerUrlJson", endpointJson);
            }
            if ((addAutoDiscovery = api.remove("addAutoDescovery")) != null) {
                logger.warn("'addAutoDescovery' is deprecated, please use 'addAutoDiscovery' instead");
                api.put("addAutoDiscovery", addAutoDiscovery);
            }
            if ((client = (HashMap)api.remove("clientApp")) != null) {
                logger.warn("'clientApp' under 'api' is deprecated, please use 'client' at application descriptor level instead.");
                this.anypointDescriptorJson.put("client", client);
            }
            if ((access = api.remove("access")) != null) {
                logger.warn("'access' under 'api' is deprecated, please move it inside 'client' instead.");
                if (client == null) {
                    client = new HashMap();
                    this.anypointDescriptorJson.put("client", client);
                }
                client.put("access", access);
            }
        }
    }

    private static Map<String, Object> readFile(File descriptorFile) throws IOException {
        if (descriptorFile.exists()) {
            String fname = descriptorFile.getName().toLowerCase();
            Object om = fname.endsWith(".yml") || fname.endsWith(".yaml") ? new YAMLMapper() : new ObjectMapper();
            om.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            return (Map)om.readValue(descriptorFile, Map.class);
        }
        return null;
    }

    public static File findAnypointFile(File basedir) {
        File file = new File(basedir, "anypoint.yml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.yaml");
        if (file.exists()) {
            return file;
        }
        file = new File(basedir, "anypoint.json");
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

