/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractOrganizationalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="prepare-publish", defaultPhase=LifecyclePhase.VALIDATE)
public class PrepareExchangePublish
extends AbstractOrganizationalMojo {
    private static final Logger logger = LoggerFactory.getLogger(PrepareExchangePublish.class);
    @Parameter(property="anypoint.adddistmngmt", defaultValue="true")
    private boolean addDistributionManagement;
    @Parameter(property="anypoint.serverid", defaultValue="anypoint-exchange-v2")
    private String serverId;
    @Parameter(property="anypoint.snapshotversionsuffix", required=false)
    private String snapshotVersionSuffic;
    @Parameter(defaultValue="true", property="anypoint.prepare.updateVersionIfSnapshot")
    private boolean updateVersionIfSnapshot;
    @Parameter(defaultValue="false", property="anypoint.prepare-publish.skip")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    @Override
    protected void doExecute() throws Exception {
        Organization organization = null;
        try {
            organization = this.getOrganization();
        }
        catch (NotFoundException | IOException e) {
            logger.warn("Unable to login to exchange to retrieve org id, skipping prepare-publish");
            return;
        }
        Artifact projectArtifact = this.project.getArtifact();
        if (!this.skip) {
            String groupId = organization.getId();
            logger.debug("Changing project groupId to " + groupId);
            this.project.setGroupId(groupId);
            if (this.project.getAttachedArtifacts() != null) {
                for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                    try {
                        logger.debug("Changing attached artifact type {}:{} groupId to {}", new Object[]{attachedArtifact.getType(), attachedArtifact.getClassifier(), groupId});
                        attachedArtifact.setGroupId(groupId);
                    }
                    catch (UnsupportedOperationException e) {
                        logger.debug("Unable to change attached artifact groupId", (Throwable)e);
                    }
                }
            }
            if (projectArtifact != null) {
                logger.debug("Changing project artifact type {}:{} groupId to {}", new Object[]{projectArtifact.getType(), projectArtifact.getClassifier(), groupId});
                projectArtifact.setGroupId(groupId);
            }
        }
        if (this.updateVersionIfSnapshot && projectArtifact != null && projectArtifact.isSnapshot()) {
            if (this.snapshotVersionSuffic == null) {
                this.snapshotVersionSuffic = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            this.snapshotVersionSuffic = this.project.getVersion() + "-" + this.snapshotVersionSuffic;
            this.project.setVersion(this.snapshotVersionSuffic);
            projectArtifact.setVersion(this.snapshotVersionSuffic);
            projectArtifact.setVersionRange(VersionRange.createFromVersion((String)this.snapshotVersionSuffic));
        }
        if (this.project.getDistributionManagement() != null && this.addDistributionManagement) {
            MavenArtifactRepository repo = new MavenArtifactRepository();
            repo.setAuthentication(new Authentication("~~~Token~~~", this.emClient.getAnypointBearerToken()));
            repo.setId(this.serverId);
            repo.setUrl(this.emClient.getExchangeMavenUrl());
            repo.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            this.project.setReleaseArtifactRepository((ArtifactRepository)repo);
        }
    }
}

