/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.LegacyDeployMojo;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.LegacyAnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentServiceImpl;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DescriptorLayers;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.ExchangeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.RuntimeDeploymentRequest;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.EMTProperties;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends LegacyDeployMojo {
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final EMTLogger emtLogger = new EMTLogger(logger);
    public static final String VAR = "emt.var";
    public static final String CLOUDHUB = "cloudhub";
    public static final String EMT_SECUREPROPERTIES = "emt.secureproperties";
    public static final String SECURE_PREFIX = "emt.secureproperty.";
    @Parameter
    protected boolean skipProvisioning;
    @Parameter
    protected boolean skipDeploy;
    @Parameter
    protected String appFile;
    @Parameter
    protected String appFilename;
    @Parameter(property="anypoint.deploy.properties", required=false)
    protected Map<String, String> properties;
    @Parameter
    protected String propertyfile;
    @Parameter(property="anypoint.deploy.propertyfile.ignoremissing", required=false)
    protected boolean ignoreMissingPropertyFile;
    @Parameter(property="anypoint.deploy.fileproperties", required=false)
    protected Map<String, String> fileProperties;
    @Parameter(property="anypoint.deploy.fileproperties.path", required=false, defaultValue="config.properties")
    protected String filePropertiesPath = "config.properties";
    @Parameter(property="anypoint.deploy.fileproperties.secure", required=false, defaultValue="false")
    protected boolean filePropertiesSecure;
    @Parameter
    protected Map<String, String> vars;
    @Parameter(property="anypoint.deploy.buildnumber")
    private String buildNumber;
    @Parameter(property="emt.provisioning.deletesnapshots")
    private Boolean deleteSnapshots;
    @Parameter
    private String target;

    @Override
    protected void doExecute() throws Exception {
        this.skipDeploy = this.getMavenProperty("emt.deploy.skip", this.skipDeploy, "anypoint.deploy.skip");
        if (!this.skipDeploy) {
            EMTProperties emtProperties = this.getEMTProperties();
            this.propertyfile = emtProperties.getProperty("emt.deploy.properties.file", this.propertyfile, new String[]{"anypoint.deploy.propertyfile"});
            this.skipProvisioning = emtProperties.getProperty("emt.provisioning.skip", Boolean.valueOf(this.skipProvisioning), new String[]{"emt.skipProvisioning", "anypoint.api.provisioning.skip"});
            this.appFile = emtProperties.getProperty("emt.app.file", this.appFile, new String[]{"anypoint.deploy.file"});
            this.appFilename = emtProperties.getProperty("emt.app.filename", this.appFilename, new String[]{"anypoint.deploy.filename"});
            this.target = emtProperties.getProperty("emt.target", this.target, new String[]{"anypoint.deploy.target", "anypoint.target"});
            this.appName = emtProperties.getProperty("emt.app.name", this.appName, new String[]{"anypoint.deploy.name"});
            this.handleDeprecated();
            if (this.project.getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven")) {
                this.project = null;
            }
            if (MavenUtils.isTemplateOrExample(this.project) && !this.force) {
                logger.warn("Project contains mule-application-template or mule-application-example, skipping deployment (use anypoint.deploy.force to force the deployment)");
                return;
            }
            if (this.appFile == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy file defined");
                }
                if (this.project == null) {
                    throw new MojoExecutionException("File not specified while running out of project");
                }
                this.appFile = MavenUtils.getProjectJar(this.project).getPath();
            }
            ApplicationIdentifier applicationIdentifier = this.project != null ? new ApplicationIdentifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()) : null;
            DeploymentServiceImpl deploymentService = new DeploymentServiceImpl(this.getOrganization().getClient(), this.anypointClient);
            try (ApplicationSource source = ApplicationSource.create((String)this.getOrganization().getId(), (LegacyAnypointClient)this.getLegacyClient(), (String)this.appFile);){
                if (this.target != null && this.target.equalsIgnoreCase("exchange")) {
                    ExchangeDeploymentRequest req = new ExchangeDeploymentRequest(this.buildNumber, applicationIdentifier, this.getOrganization(), source, null);
                    ApplicationIdentifier appId = deploymentService.deployToExchange(req);
                    emtLogger.info(EMTLogger.Product.EXCHANGE, "Published application to exchange: " + appId.getGroupId() + ":" + appId.getArtifactId() + ":" + appId.getVersion(), new Object[0]);
                }
                if (this.vars == null) {
                    this.vars = new HashMap<String, String>();
                }
                this.vars.putAll(this.findPrefixedProperties(VAR));
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>();
                }
                this.properties.putAll(this.findPrefixedProperties("anypoint.deploy.properties."));
                this.properties.putAll(this.findPrefixedProperties("emt.property."));
                HashSet<String> secureProperties = new HashSet<String>();
                for (Map.Entry e : emtProperties.getProperties().entrySet()) {
                    if (!((String)e.getKey()).startsWith(SECURE_PREFIX) || !"true".equalsIgnoreCase((String)e.getValue())) continue;
                    secureProperties.add(((String)e.getKey()).substring(SECURE_PREFIX.length()));
                }
                JsonNode deploymentParametersOverridesLegacy = this.getDeploymentParametersOverrides();
                Environment environment = this.getEnvironment();
                environment.getOrganization().validateObject();
                RuntimeDeploymentRequest request = new RuntimeDeploymentRequest(this.appFilename != null ? this.appFilename : source.getFileName(), this.appName, source.getArtifactId(), this.buildNumber, this.vars, this.properties, StringUtils.isNotBlank((String)this.propertyfile) ? new File(this.propertyfile) : null, this.ignoreMissingPropertyFile, this.target, environment, this.injectEnvInfo.booleanValue(), this.skipWait, this.skipProvisioning, deploymentParametersOverridesLegacy);
                request.addSecureProperties(secureProperties);
                request.setFileProperties(this.fileProperties);
                request.setFilePropertiesPath(this.filePropertiesPath);
                request.setFilePropertiesSecure(this.filePropertiesSecure);
                request.setDeleteSnapshots(this.deleteSnapshots != null && this.deleteSnapshots != false);
                ObjectNode appDescJson = source.getAnypointDescriptor();
                deploymentService.deploy(request, appDescJson, new DescriptorLayers(emtProperties), source);
            }
        } else {
            logger.info("Deployment skipped");
        }
    }

    private void handleDeprecated() {
        if (this.chMuleVersionName == null && this.muleVersionName != null) {
            logger.warn("muleVersionName (anypoint.deploy.ch.muleversion) is deprecated, please use chMuleVersionName (anypoint.deploy.ch.runtime.version) instead");
            this.chMuleVersionName = this.muleVersionName;
        }
    }
}

