/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.cli.EMTCli;
import com.aeontronix.enhancedmule.tools.cli.ShellCmd;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jline.reader.impl.DefaultParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@Mojo(name="shell", requiresProject=false)
public class ShellMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(ShellMojo.class);
    @Parameter(name="command", property="cmd")
    private String command;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block6: {
            if (StringUtils.isNotBlank((String)this.command)) {
                try {
                    EMTCli cli = new EMTCli();
                    CommandLine commandLine = new CommandLine((Object)cli);
                    commandLine.setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
                    commandLine.setUsageHelpAutoWidth(true);
                    commandLine.setCaseInsensitiveEnumValuesAllowed(true);
                    commandLine.setPosixClusteredShortOptionsAllowed(false);
                    logger.info("Executing command");
                    int ret = commandLine.execute(new DefaultParser().parse(this.command, 0).words().toArray(new String[0]));
                    if (ret != 0) {
                        throw new MojoExecutionException("Command returned status code: " + ret);
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            try {
                new ShellCmd().call();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

