/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.AbstractOrganizationalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.Environment;
import com.aeontronix.enhancedmule.tools.anypoint.NotFoundException;
import com.aeontronix.enhancedmule.tools.config.ProfileNotFoundException;
import com.aeontronix.enhancedmule.tools.util.EMTProperties;
import java.io.IOException;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEnvironmentalMojo
extends AbstractOrganizationalMojo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEnvironmentalMojo.class);
    private Environment environment;
    @Parameter
    protected String env;

    public synchronized Environment getEnvironment() throws NotFoundException, IOException, ProfileNotFoundException {
        if (this.environment == null) {
            this.env = this.getEnvProperty();
            if (this.env == null) {
                this.env = this.configProfile.getDefaultEnv();
                if (this.env == null) {
                    throw new IllegalStateException("Environment not set, please set using emt.env or set a default environment in your configuration profile");
                }
            }
            this.environment = this.getOrganization().findEnvironmentByNameOrId(this.env);
        }
        return this.environment;
    }

    protected String getEnvProperty() {
        return this.getMavenProperty("emt.env", this.env, "anypoint.env");
    }

    @Override
    public EMTProperties getEMTProperties() throws NotFoundException, IOException, ProfileNotFoundException {
        if (StringUtils.isNotBlank((String)this.getEnvProperty())) {
            this.getEnvironment();
            return new EMTProperties(this.getMavenProperties(), this.environment.getId(), this.environment.getName(), this.environment.getType());
        }
        return new EMTProperties(this.getMavenProperties(), null, null, null);
    }
}

