/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationDeployerScriptBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-deploy-script", requiresProject=true, defaultPhase=LifecyclePhase.PACKAGE)
public class CreateDeployScriptMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="emt.deployscript.projectbasedir", defaultValue="${project.basedir}")
    private File projectBasedir;
    @Parameter(property="emt.deployscript.emtversion")
    private String emtVersion;
    @Parameter(property="emt.deployscript.zipfilename", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-deployer.zip")
    private File deployerZip;
    @Parameter(property="emt.deployscript.mvnopts", defaultValue="-B -ntp -e")
    private String mvnOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            new ApplicationDeployerScriptBuilder(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()).withMvnWrapperDir(this.projectBasedir).withEMTVersion(this.emtVersion).buildZipArchive(this.deployerZip);
            DefaultArtifact zipDeployArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "zip", "deployer", (ArtifactHandler)new DefaultArtifactHandler("zip"));
            zipDeployArtifact.setFile(this.deployerZip);
            this.project.addAttachedArtifact((Artifact)zipDeployArtifact);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

