/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.FileUtils;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.ApplicationDescriptorProcessor;
import com.aeontronix.enhancedmule.tools.application.ApplicationDescriptor;
import com.aeontronix.enhancedmule.tools.application.ApplicationSourceMetadata;
import com.aeontronix.enhancedmule.tools.util.JsonHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorProcessorImpl
implements ApplicationDescriptorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorProcessorImpl.class);
    public static final String DESCRIPTION = "description";
    public static final String ID = "id";
    public static final String API = "api";
    private final MavenProject project;
    private final ObjectMapper objectMapper;
    private ObjectNode applicationDescriptor;

    public ApplicationDescriptorProcessorImpl(@Nullable String descriptor, @NotNull MavenProject project, File assetPagesDir, File apiSpecDir, ApplicationSourceMetadata applicationSourceMetadata) throws IOException {
        this.project = project;
        this.objectMapper = JsonHelper.createMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        File descriptorFile = StringUtils.isNotBlank((String)descriptor) ? new File(descriptor) : ApplicationDescriptor.findAnypointFile((File)project.getBasedir());
        this.applicationDescriptor = descriptorFile == null ? this.objectMapper.createObjectNode() : ApplicationDescriptorProcessorImpl.readFile(descriptorFile);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setApplicationDescriptor(String json) throws JsonProcessingException {
        this.applicationDescriptor = (ObjectNode)this.objectMapper.readTree(json);
    }

    @Override
    public void writeToFile(File file, boolean addToProject) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            FileUtils.mkdir((File)parentFile);
        }
        this.objectMapper.writeValue(file, (Object)this.applicationDescriptor);
        if (addToProject) {
            Resource resource = new Resource();
            resource.setDirectory(parentFile.getPath());
            resource.setIncludes(Collections.singletonList(file.getName()));
            this.project.addResource(resource);
        }
    }

    @Override
    public ApplicationDescriptor getAnypointDescriptor() throws IOException {
        return (ApplicationDescriptor)this.objectMapper.readerFor(ApplicationDescriptor.class).readValue((JsonNode)this.applicationDescriptor);
    }

    @Override
    public ObjectNode getApplicationDescriptorJson() {
        return this.applicationDescriptor;
    }

    @Override
    public void legacyConvert() {
        ObjectNode api = (ObjectNode)this.applicationDescriptor.get(API);
        if (api != null) {
            JsonNode access;
            ObjectNode client;
            JsonNode addAutoDiscovery;
            JsonNode endpointJson;
            JsonNode endpoint;
            JsonNode assetCreate;
            JsonNode assetMainFile;
            JsonNode description;
            JsonNode version;
            JsonNode assetId = api.remove("assetId");
            JsonNode assetVersion = api.remove("assetVersion");
            ObjectNode asset = (ObjectNode)api.get("asset");
            if (asset == null) {
                asset = this.objectMapper.createObjectNode();
                api.set("asset", (JsonNode)asset);
            }
            if (assetId != null || assetVersion != null) {
                logger.warn("api->assetId and api->assetVersion are deprecated, use api->asset->id and api->asset->version instead");
                asset.set(ID, assetId);
                asset.set("version", assetVersion);
            }
            ApplicationDescriptorProcessorImpl.relocate(api, "exchangeTags", "api->exchangeTags", asset, "tags", "api->asset->tags");
            JsonNode name = ApplicationDescriptorProcessorImpl.relocate(api, "name", "api->name", asset, "name", "api->asset->name");
            ApplicationDescriptorProcessorImpl.relocate(api, "create", "api->create", asset, "create", "api->asset->create");
            ApplicationDescriptorProcessorImpl.relocate(api, "type", "api->type", asset, "type", "api->asset->type");
            JsonNode apiVersion = api.remove("apiVersion");
            if (apiVersion != null && api.get("version") == null) {
                logger.warn("'api->apiVersion' is deprecated, use api->asset->apiVersion instead");
                asset.set("apiVersion", apiVersion);
            }
            if ((version = api.remove("version")) != null) {
                asset.set("apiVersion", name);
                logger.warn("api->version deprecated, use api->asset->apiVersion instead");
            }
            if ((description = api.remove(DESCRIPTION)) != null) {
                asset.set(DESCRIPTION, description);
                logger.warn("api->description deprecated, use api->asset->description instead");
            }
            if ((assetMainFile = api.remove("assetMainFile")) != null) {
                asset.set("assetMainFile", description);
                logger.warn("api->assetMainFile deprecated, use api->asset->assetMainFile instead");
            }
            if ((assetCreate = api.remove("assetCreate")) != null) {
                asset.set("create", assetCreate);
                logger.warn("api->assetCreate deprecated, use api->asset->create instead");
            }
            if ((endpoint = api.remove("endpoint")) != null) {
                logger.warn("'endpoint' is deprecated, please use implementationUrl and/or consumerUrl instead");
                api.set("implementationUrl", endpoint);
                api.set("consumerUrl", endpoint);
            }
            if ((endpointJson = api.remove("endpointJson")) != null) {
                logger.warn("'endpointJson' is deprecated, please use consumerUrlJson instead");
                api.set("consumerUrlJson", endpointJson);
            }
            if ((addAutoDiscovery = api.remove("addAutoDescovery")) != null) {
                logger.warn("'addAutoDescovery' is deprecated, please use 'addAutoDiscovery' instead");
                api.set("addAutoDiscovery", addAutoDiscovery);
            }
            if ((client = (ObjectNode)api.remove("clientApp")) != null) {
                logger.warn("'clientApp' under 'api' is deprecated, please use 'client' at application descriptor level instead.");
                this.applicationDescriptor.set("client", (JsonNode)client);
            }
            if ((access = api.remove("access")) != null) {
                logger.warn("'access' under 'api' is deprecated, please move it inside 'client' instead.");
                if (client == null) {
                    client = this.objectMapper.createObjectNode();
                    this.applicationDescriptor.set("client", (JsonNode)client);
                }
                client.set("access", access);
            }
            ApplicationDescriptorProcessorImpl.relocate(asset, "assetId", "asset->assetId", asset, ID, "asset->id");
            if (client == null) {
                client = (ObjectNode)this.applicationDescriptor.get("client");
            }
            if (client != null && (access = client.get("access")) != null) {
                for (JsonNode jsonNode : access) {
                    JsonNode envId = jsonNode.get("envId");
                    if (envId == null) continue;
                    logger.warn("client->access->envId is deprecated, use client->access->env instead");
                    ((ObjectNode)jsonNode).set("env", envId);
                }
            }
        }
    }

    private static JsonNode relocate(ObjectNode oldParent, String oldName, String oldLocationTxt, ObjectNode newParent, String newName, String newLocationTxt) {
        JsonNode node = oldParent.remove(oldName);
        if (node != null) {
            newParent.set(newName, node);
            logger.warn(oldLocationTxt + " is deprecated, use " + newLocationTxt + " instead");
        }
        return node;
    }

    private static ObjectNode readFile(File descriptorFile) throws IOException {
        if (descriptorFile.exists()) {
            String fname = descriptorFile.getName().toLowerCase();
            Object om = fname.endsWith(".yml") || fname.endsWith(".yaml") ? new YAMLMapper() : new ObjectMapper();
            om.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
            return (ObjectNode)om.readTree(descriptorFile);
        }
        return null;
    }
}

