/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.commons.xml.XmlUtils;
import com.aeontronix.enhancedmule.tools.application.ApplicationSourceMetadata;
import com.aeontronix.enhancedmule.tools.application.api.apikit.APIKitSpec;
import com.aeontronix.enhancedmule.tools.util.APISpecHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ApplicationSourceMetadataProjectSourceImpl
extends ApplicationSourceMetadata {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationSourceMetadataProjectSourceImpl.class);
    private final MavenProject project;
    private final File assetPagesDir;
    private final File apiSpecDir;

    public ApplicationSourceMetadataProjectSourceImpl(MavenProject project, File assetPagesDir, File apiSpecDir) {
        this.project = project;
        this.assetPagesDir = assetPagesDir;
        this.apiSpecDir = apiSpecDir;
    }

    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    public String getName() {
        return this.project.getName();
    }

    public String getVersion() {
        return this.project.getVersion();
    }

    public String getDescription() {
        return this.project.getDescription();
    }

    public File findIcon() {
        for (String fn : Arrays.asList("icon.svg", "icon.png", "icon.jpeg", "icon.jpg", "icon.gif")) {
            File f = new File(this.project.getBasedir(), fn);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    @Nullable
    public String findAPISpecFile(String ... names) {
        if (this.apiSpecDir != null && this.apiSpecDir.exists()) {
            return ApplicationSourceMetadataProjectSourceImpl.findAPISpecFile(names != null ? Arrays.asList(names) : Collections.emptyList(), this.apiSpecDir);
        }
        return null;
    }

    public APISpecHelper.APISpecVersion findAPISpecVersion(String assetMainFile) throws IOException {
        File apiSpecFile = new File(this.apiSpecDir, assetMainFile);
        return APISpecHelper.findVersion((File)apiSpecFile);
    }

    @Nullable
    public static String findAPISpecFile(List<String> names, File dir) {
        if (dir.exists()) {
            ArrayList<String> filenames = new ArrayList<String>(names);
            filenames.add("api");
            for (String apiExt : apiExts) {
                for (String filename : filenames) {
                    String apiFile = filename + apiExt;
                    if (!new File(dir, apiFile).exists()) continue;
                    return apiFile;
                }
            }
        }
        return null;
    }

    private File findDependencyFile(String groupId, String artifactId, String version) {
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                File file;
                if (!artifact.getArtifactId().equals(groupId) || !artifact.getGroupId().equals(artifactId) || !artifact.getVersion().equals(version) || !(file = artifact.getFile()).exists()) continue;
                return file;
            }
        }
        return null;
    }

    public String getFileStrContent(String path) throws IOException {
        try (FileInputStream fis = new FileInputStream(this.project.getBasedir() + File.separator + path.replace("/", File.separator));){
            String string = IOUtils.toString((InputStream)fis);
            return string;
        }
    }

    @NotNull
    public Map<String, String> getPortalPages() throws IOException {
        File[] files;
        HashMap<String, String> pages = new HashMap<String, String>();
        if (this.assetPagesDir != null && this.assetPagesDir.exists() && (files = this.assetPagesDir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                String fileName;
                int idx;
                if (!file.isFile() || (idx = (fileName = file.getName()).indexOf(".")) == -1) continue;
                pages.put(fileName.substring(0, idx), IOUtils.toString((File)file));
            }
        }
        return pages;
    }

    public JsonNode getJsonContentFromDependencyArchive(String groupId, String artifactId, String version, String path) throws IOException {
        File file = this.findDependencyFile(groupId, artifactId, version);
        if (file == null) {
            throw new IOException("Dependency file not found");
        }
        ZipFile zipFile = new ZipFile(file);
        ZipEntry entry = zipFile.getEntry("exchange.json");
        if (entry != null) {
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                JsonNode jsonNode = new ObjectMapper().readTree(inputStream);
                return jsonNode;
            }
        }
        throw new IOException("File not found in dependency archive");
    }

    @NotNull
    public List<APIKitSpec> findAPIKitSpecs() throws IOException {
        ArrayList<APIKitSpec> list = new ArrayList<APIKitSpec>();
        File outputDir = new File(this.project.getBuild().getOutputDirectory());
        File[] files = outputDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));
        if (files != null) {
            for (File file : files) {
                try {
                    Document xmlDoc = XmlUtils.parse((File)file, (boolean)true);
                    list.addAll(this.findAPIKitSpec(xmlDoc));
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
        }
        return list;
    }
}

