/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.LegacyDeployMojo;
import com.aeontronix.enhancedmule.tools.anypoint.AnypointClient;
import com.aeontronix.enhancedmule.tools.anypoint.application.ApplicationIdentifier;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentRequest;
import com.aeontronix.enhancedmule.tools.anypoint.application.deploy.DeploymentServiceImpl;
import com.aeontronix.enhancedmule.tools.legacy.deploy.ApplicationSource;
import com.aeontronix.enhancedmule.tools.util.EMTLogger;
import com.aeontronix.enhancedmule.tools.util.MavenUtils;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="deploy", requiresProject=false, defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends LegacyDeployMojo {
    public static final String ANYPOINT_DEPLOY_PROPERTIES = "anypoint.deploy.properties.";
    private static final Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    private static final EMTLogger emtLogger = new EMTLogger(logger);
    public static final String VAR = "var";
    public static final String CLOUDHUB = "cloudhub";
    @Parameter(property="emt.skipProvisioning")
    protected boolean skipProvisioning;
    @Parameter(property="anypoint.deploy.skip")
    protected boolean skipDeploy;
    @Parameter(property="anypoint.deploy.file")
    protected String file;
    @Parameter(property="anypoint.deploy.filename")
    protected String filename;
    @Parameter(property="anypoint.deploy.properties", required=false)
    protected Map<String, String> properties;
    @Parameter(property="anypoint.deploy.propertyfile", required=false)
    protected File propertyfile;
    @Parameter(property="anypoint.deploy.propertyfile.ignoremissing", required=false)
    protected boolean ignoreMissingPropertyFile;
    @Parameter(property="anypoint.deploy.fileproperties", required=false)
    protected Map<String, String> fileProperties;
    @Parameter(property="anypoint.deploy.fileproperties.path", required=false, defaultValue="config.properties")
    protected String filePropertiesPath = "config.properties";
    @Parameter(property="anypoint.deploy.fileproperties.secure", required=false, defaultValue="false")
    protected boolean filePropertiesSecure;
    @Parameter
    protected Map<String, String> vars;
    @Parameter(property="anypoint.deploy.buildnumber")
    private String buildNumber;
    @Parameter(property="emt.provisioning.deletesnapshots")
    private Boolean deleteSnapshots;
    @Parameter(property="anypoint.deploy.injectEnvInfo", defaultValue="true")
    protected Boolean injectEnvInfo;
    @Parameter(property="anypoint.deploy.force")
    protected boolean force;
    @Parameter(property="anypoint.deploy.skipwait")
    protected boolean skipWait;
    @Parameter(name="target", property="anypoint.deploy.target")
    protected String target;

    @Override
    protected void doExecute() throws Exception {
        if (!this.skipDeploy) {
            this.handleDeprecated();
            if (this.project.getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven")) {
                this.project = null;
            }
            if (MavenUtils.isTemplateOrExample(this.project) && !this.force) {
                logger.warn("Project contains mule-application-template or mule-application-example, skipping deployment (use anypoint.deploy.force to force the deployment)");
                return;
            }
            if (this.file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy file defined");
                }
                if (this.project == null) {
                    throw new MojoExecutionException("File not specified while running out of project");
                }
                this.file = MavenUtils.getProjectJar(this.project).getPath();
            }
            DeploymentServiceImpl deploymentService = new DeploymentServiceImpl(this.getOrganization().getClient());
            try (ApplicationSource source = ApplicationSource.create((String)this.getOrganization().getId(), (AnypointClient)this.getClient(), (String)this.file);){
                if (this.target != null && this.target.equalsIgnoreCase("exchange")) {
                    DeploymentRequest request = new DeploymentRequest(this.filename != null ? this.filename : source.getFileName(), this.buildNumber, this.vars, this.properties, this.propertyfile, this.ignoreMissingPropertyFile, this.target, this.getOrganization(), null, this.injectEnvInfo.booleanValue(), this.skipWait, this.skipProvisioning, source);
                    ApplicationIdentifier appId = deploymentService.deployToExchange(request);
                    emtLogger.info(EMTLogger.Product.EXCHANGE, "Published application to exchange: " + appId.getGroupId() + ":" + appId.getArtifactId() + ":" + appId.getVersion(), new Object[0]);
                } else {
                    this.vars = this.findPrefixProperties(this.vars, VAR);
                    this.properties = this.findPrefixProperties(this.properties, ANYPOINT_DEPLOY_PROPERTIES);
                    DeploymentRequest request = new DeploymentRequest(this.filename != null ? this.filename : source.getFileName(), this.buildNumber, this.vars, this.properties, this.propertyfile, this.ignoreMissingPropertyFile, this.target, null, this.getEnvironment(), this.injectEnvInfo.booleanValue(), this.skipWait, this.skipProvisioning, source);
                    Properties userProperties = this.session.getUserProperties();
                    for (Object key : userProperties.keySet()) {
                        String keyStr = key.toString();
                        if (!keyStr.startsWith("-O")) continue;
                        request.setOverrideParameter(keyStr.substring(2), userProperties.getProperty(keyStr));
                    }
                    request.setFileProperties(this.fileProperties);
                    request.setFilePropertiesPath(this.filePropertiesPath);
                    request.setFilePropertiesSecure(this.filePropertiesSecure);
                    request.setDeleteSnapshots(this.deleteSnapshots != null && this.deleteSnapshots != false);
                    deploymentService.deploy(request);
                }
            }
        }
    }

    private void handleDeprecated() {
    }
}

