/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.commons.StringUtils;
import com.aeontronix.enhancedmule.tools.AbstractCryptoMojo;
import com.aeontronix.kryptotek.CryptoUtils;
import com.aeontronix.kryptotek.EncryptionException;
import com.aeontronix.kryptotek.key.AESKey;
import com.aeontronix.kryptotek.key.EncryptionKey;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="props-encrypt", requiresProject=false)
public class EncryptPropertiesMojo
extends AbstractCryptoMojo {
    @Override
    protected JsonNode processValue(AESKey key, JsonNode value) throws Exception {
        if (value.isObject()) {
            JsonNode encrypted = value.get("encrypted");
            if (!(encrypted != null && encrypted.booleanValue() || (value = value.get("value")) == null)) {
                ((ObjectNode)value).set("value", (JsonNode)new TextNode(this.encrypt((EncryptionKey)key, value.textValue())));
            }
            return value;
        }
        if (value.isTextual()) {
            ObjectNode v = this.objectMapper.createObjectNode();
            v.set("encrypted", (JsonNode)BooleanNode.TRUE);
            v.set("value", (JsonNode)new TextNode(this.encrypt((EncryptionKey)key, value.textValue())));
            return v;
        }
        return null;
    }

    private String encrypt(EncryptionKey key, String value) throws EncryptionException {
        return StringUtils.base64Encode((byte[])CryptoUtils.encrypt((EncryptionKey)key, (byte[])StringUtils.utf8((String)value)));
    }

    @Override
    protected boolean isProcessingRequired(JsonNode property) {
        JsonNode secure = property.get("secure");
        return secure != null && secure.booleanValue();
    }
}

