/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools;

import com.aeontronix.enhancedmule.tools.AbstractOrganizationalMojo;
import com.aeontronix.enhancedmule.tools.anypoint.Organization;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-publish", defaultPhase=LifecyclePhase.VALIDATE)
public class PrepareExchangePublish
extends AbstractOrganizationalMojo {
    @Parameter(property="anypoint.adddistmngmt", defaultValue="true")
    private boolean addDistributionManagement;
    @Parameter(property="anypoint.serverid", defaultValue="anypoint-exchange-v2")
    private String serverId;
    @Parameter(property="anypoint.snapshotversionsuffix", required=false)
    private String snapshotVersionSuffic;
    @Parameter(defaultValue="true", property="anypoint.prepare.updateVersionIfSnapshot")
    private boolean updateVersionIfSnapshot;
    @Parameter(defaultValue="false", property="anypoint.prepare-publish.skip")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    @Override
    protected void doExecute() throws Exception {
        Organization organization = this.getOrganization();
        if (!this.skip) {
            String groupId = organization.getId();
            this.project.setGroupId(groupId);
            if (this.project.getAttachedArtifacts() != null) {
                for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                    attachedArtifact.setGroupId(groupId);
                }
            }
            if (this.project.getArtifact() != null) {
                this.project.getArtifact().setGroupId(groupId);
            }
        }
        if (this.updateVersionIfSnapshot && this.project.getArtifact() != null && this.project.getArtifact().isSnapshot()) {
            if (this.snapshotVersionSuffic == null) {
                this.snapshotVersionSuffic = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            this.snapshotVersionSuffic = this.project.getVersion() + "-" + this.snapshotVersionSuffic;
            this.project.setVersion(this.snapshotVersionSuffic);
            if (this.project.getArtifact() != null) {
                this.project.getArtifact().setVersion(this.snapshotVersionSuffic);
                this.project.getArtifact().setVersionRange(VersionRange.createFromVersion((String)this.snapshotVersionSuffic));
            }
        }
        if (this.project.getDistributionManagement() == null && this.addDistributionManagement) {
            MavenArtifactRepository repo = new MavenArtifactRepository();
            repo.setAuthentication(new Authentication(this.username, this.password));
            repo.setId(this.serverId);
            repo.setUrl(this.emClient.getExchangeMavenUrl());
            repo.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            this.project.setReleaseArtifactRepository((ArtifactRepository)repo);
        }
    }
}

