/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.enhancedmule.tools.maven;

import com.aeontronix.enhancedmule.config.ConfigProfile;
import com.aeontronix.enhancedmule.config.EMConfig;
import com.aeontronix.enhancedmule.tools.cli.LoginCmd;
import com.aeontronix.enhancedmule.tools.client.EMTClient;
import com.aeontronix.enhancedmule.tools.client.LoginHelper;
import java.io.File;
import java.net.URI;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="login", requiresProject=false)
public class LoginMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(LoginCmd.class);
    @Parameter(property="emt.server.url")
    private URI serverUrl;
    @Parameter(property="emt.maven.settings.file")
    private File mvnSettingsFile;
    @Parameter(property="emt.maven.settings")
    private String mavenSettings;
    @Parameter(property="emt.profile")
    private String profile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.mvnSettingsFile == null) {
                this.mvnSettingsFile = new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings.xml");
            }
            EMConfig configFile = EMConfig.findConfigFile();
            ConfigProfile configProfile = configFile.getOrCreateProfile(this.profile);
            configProfile.setServerUrl(this.serverUrl);
            EMTClient emtClient = new EMTClient(configProfile);
            LoginHelper.login((File)this.mvnSettingsFile, (String)this.mavenSettings, (EMTClient)emtClient, (ConfigProfile)configProfile);
            configFile.save();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

