/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis;

import com.aeontronix.genesis.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class DirectoryResourceLoader
implements ResourceLoader {
    private File dir;

    public DirectoryResourceLoader(File dir) {
        this.dir = dir;
    }

    @Override
    public InputStream loadResource(String resourcePath) {
        File f = new File(this.dir + File.separator + resourcePath.replace("/", File.separator));
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public Set<String> listFiles(String resourcePath) {
        HashSet<String> results = new HashSet<String>();
        this.buildFileList(results, "", new File(this.dir, resourcePath));
        return results;
    }

    public void buildFileList(HashSet<String> results, String basePath, File dir) {
        File[] files;
        if (dir != null && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.buildFileList(results, basePath + file.getName() + "/", file);
                    continue;
                }
                results.add(basePath + file.getName());
            }
        }
    }
}

