/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis;

import com.aeontronix.commons.FileUtils;
import com.aeontronix.commons.StringUtils;
import com.aeontronix.commons.io.IOUtils;
import com.aeontronix.genesis.Template;
import com.aeontronix.genesis.TemplateExecutionException;
import com.aeontronix.genesis.TemplateExecutor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TFile {
    protected String path;
    protected String content;
    protected String ignore;
    @JsonIgnore
    protected File file;
    @JsonIgnore
    protected Template template;
    @JsonProperty
    private Boolean process;
    @JsonProperty
    private String encoding;
    @JsonProperty
    private String resource;

    public TFile() {
    }

    public TFile(String path) {
        this.path = path;
    }

    public void create(TemplateExecutor exec) throws TemplateExecutionException {
        if (!Boolean.parseBoolean(this.ignore)) {
            try {
                File parent = this.file.getParentFile();
                if (!parent.exists()) {
                    FileUtils.mkdirs((File)parent);
                }
                try (FileOutputStream os = new FileOutputStream(this.file);
                     InputStream is = this.getContent(exec);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException e) {
                throw new TemplateExecutionException(e);
            }
        }
    }

    private InputStream getContent(TemplateExecutor exec) throws TemplateExecutionException {
        try {
            if (this.content == null && this.resource == null) {
                this.resource = this.path;
            }
            if (StringUtils.isNotBlank((String)this.resource)) {
                String resourcePath = exec.filter(this.resource);
                InputStream is = this.template.getFileResource(resourcePath);
                if (is == null) {
                    throw new TemplateExecutionException("File resource missing: " + resourcePath);
                }
                this.content = IOUtils.toString((InputStream)is, (String)this.getEncoding());
            }
            if (this.content == null) {
                throw new TemplateExecutionException("Content missing: " + this.path);
            }
            if (this.process == null || this.process.booleanValue()) {
                return new ByteArrayInputStream(exec.filter(this.path, this.content).getBytes(this.getEncoding()));
            }
            return new ByteArrayInputStream(this.content.getBytes(this.getEncoding()));
        }
        catch (IOException e) {
            throw new TemplateExecutionException(e);
        }
    }

    public String getEncoding() {
        return this.encoding != null ? this.encoding : "UTF-8";
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public boolean isConflict() {
        return this.file.exists();
    }

    public void process(TemplateExecutor exec) throws TemplateExecutionException {
        this.template = exec.getTemplate();
        this.path = exec.filter(this.path);
        this.file = new File(exec.getTarget() + File.separator + this.path);
        this.ignore = exec.filter(this.ignore);
        this.encoding = exec.filter(this.encoding);
        this.resource = exec.filter(this.resource);
    }

    public Boolean getProcess() {
        return this.process;
    }

    public void setProcess(Boolean process) {
        this.process = process;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }
}

