/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis;

import com.aeontronix.commons.UnexpectedException;
import com.aeontronix.genesis.ClasspathResourceLoader;
import com.aeontronix.genesis.DirectoryResourceLoader;
import com.aeontronix.genesis.InvalidTemplateException;
import com.aeontronix.genesis.ResourceLoader;
import com.aeontronix.genesis.TFile;
import com.aeontronix.genesis.TemplateNotFoundException;
import com.aeontronix.genesis.ZipResourceLoader;
import com.aeontronix.genesis.step.Step;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private static final Logger logger = LoggerFactory.getLogger(Template.class);
    private String id;
    private String title;
    private String resourcePath = "files";
    private List<Step> steps;
    private List<TFile> files;
    private boolean overwrite;
    private List<String> ignore;
    private ResourceLoader resourceLoader;

    public Template() {
    }

    Template(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(required=true)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty
    public List<String> getIgnore() {
        return this.ignore;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
    }

    public List<TFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<TFile> files) {
        this.files = files;
    }

    @JsonProperty
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public static Template createFromClasspath(String dir, String filename) throws TemplateNotFoundException, InvalidTemplateException, IOException {
        URL url = Template.class.getResource(dir + "/" + filename);
        if (url == null) {
            throw new TemplateNotFoundException("Template not found: " + url);
        }
        Template template = Template.create(url.toString());
        if (template == null) {
            throw new TemplateNotFoundException("Template not found: " + url);
        }
        template.setResourceLoader(new ClasspathResourceLoader());
        template.setResourcePath(dir);
        return template;
    }

    public static Template create(String templatePath) throws TemplateNotFoundException, InvalidTemplateException, IOException {
        String lpath = templatePath.toLowerCase();
        File file = null;
        if (lpath.equals("classpath://")) {
            return Template.loadTemplate(new ClasspathResourceLoader());
        }
        try {
            URL url = new URL(templatePath);
            if (url.getProtocol().equalsIgnoreCase("file")) {
                file = new File(url.toURI());
            } else {
                if (lpath.endsWith(".json")) {
                    return Template.loadTemplateFile(url, false);
                }
                if (lpath.endsWith(".yml")) {
                    return Template.loadTemplateFile(url, true);
                }
                if (lpath.endsWith(".jar") || lpath.endsWith(".zip")) {
                    throw new RuntimeException("non-file url not supported at tis time");
                }
            }
        }
        catch (MalformedURLException e) {
            file = new File(templatePath);
        }
        catch (URISyntaxException e) {
            throw new UnexpectedException((Throwable)e);
        }
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                return Template.loadTemplate(new DirectoryResourceLoader(file));
            }
            if (lpath.endsWith(".json")) {
                return Template.loadTemplateFile(file, false);
            }
            if (lpath.endsWith(".yml")) {
                return Template.loadTemplateFile(file, true);
            }
            if (lpath.endsWith(".jar") || lpath.endsWith(".zip")) {
                return Template.loadTemplate(new ZipResourceLoader(file));
            }
        } else {
            throw new TemplateNotFoundException("Template " + templatePath + " not found");
        }
        return null;
    }

    public static Template loadTemplate(ResourceLoader resourceLoader) throws IOException, InvalidTemplateException {
        try (InputStream is = resourceLoader.loadResource("genesis-template.json");){
            if (is != null) {
                Template template = Template.loadTemplateFile(is, false);
                template.setResourceLoader(resourceLoader);
                Template template2 = template;
                return template2;
            }
        }
        is = resourceLoader.loadResource("genesis-template.yml");
        try {
            if (is == null) {
                throw new InvalidTemplateException("Unable to find template file in archive");
            }
            Template template = Template.loadTemplateFile(is, true);
            template.setResourceLoader(resourceLoader);
            Template template3 = template;
            return template3;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static Template loadTemplateFile(InputStream is, boolean yaml) throws IOException {
        ObjectMapper objectMapper = Template.getObjectMapper(yaml);
        return (Template)objectMapper.readValue(is, Template.class);
    }

    @NotNull
    private static ObjectMapper getObjectMapper(boolean yaml) {
        if (yaml) {
            return new ObjectMapper((JsonFactory)new YAMLFactory());
        }
        return new ObjectMapper();
    }

    private static Template loadTemplateFile(URL url, boolean yaml) throws IOException {
        ObjectMapper objectMapper = Template.getObjectMapper(yaml);
        return (Template)objectMapper.readValue(url, Template.class);
    }

    private static Template loadTemplateFile(File file, boolean yaml) throws InvalidTemplateException {
        Template template;
        FileInputStream is = new FileInputStream(file);
        try {
            template = Template.loadTemplateFile(is, yaml);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidTemplateException(e);
            }
        }
        is.close();
        return template;
    }

    private static InputStream getStream(String path) {
        InputStream is;
        File file = new File(path);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((is = ClassLoader.getSystemResourceAsStream(path)) != null) {
            return is;
        }
        is = Template.class.getResourceAsStream((path.startsWith("/") ? "" : "/") + path);
        return is;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputStream getFileResource(String path) throws IOException {
        StringBuilder fullPath = new StringBuilder(this.resourcePath.startsWith("/") ? this.resourcePath.substring(1) : this.resourcePath);
        if (this.resourcePath.endsWith("/") && path.startsWith("/")) {
            path = path.substring(1);
        } else if (!this.resourcePath.endsWith("/") && !path.startsWith("/")) {
            path = "/" + path;
        }
        fullPath.append(path);
        return this.resourceLoader.loadResource(fullPath.toString());
    }
}

