/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis;

import com.aeontronix.commons.FileUtils;
import com.aeontronix.commons.TempDir;
import com.aeontronix.genesis.TFile;
import com.aeontronix.genesis.Template;
import com.aeontronix.genesis.TemplateExecutionException;
import com.aeontronix.genesis.step.FilesStep;
import com.aeontronix.genesis.step.Step;
import com.aeontronix.genesis.ui.UserInterface;
import com.aeontronix.genesis.ui.UserInterfaceCLIImpl;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TemplateExecutor.class);
    private final Configuration fmCfg;
    private Template template;
    private File target;
    private List<Step> steps;
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Map<String, String> defaultOverrides = new HashMap<String, String>();
    private final Map<String, String> defaults = new HashMap<String, String>();
    private boolean nonInteractive;
    private boolean isHeadless;
    private boolean advanced;
    private Set<Pattern> ignore;
    private UserInterface ui;

    public TemplateExecutor(Template template, File target) {
        this.template = template;
        this.target = target;
        this.fmCfg = new Configuration(Configuration.VERSION_2_3_28);
        this.fmCfg.setDefaultEncoding("UTF-8");
        this.fmCfg.setLogTemplateExceptions(false);
        this.fmCfg.setWrapUncheckedExceptions(true);
        this.ui = new UserInterfaceCLIImpl();
    }

    public Set<Pattern> getIgnore() {
        return this.ignore;
    }

    public Template getTemplate() {
        return this.template;
    }

    public File getTarget() {
        return this.target;
    }

    public UserInterface getUi() {
        return this.ui;
    }

    public void setUi(UserInterface ui) {
        this.ui = ui;
    }

    public synchronized String filter(String text) throws TemplateExecutionException {
        return this.filter("template", text);
    }

    public synchronized String filter(String templateName, String text) throws TemplateExecutionException {
        if (text == null) {
            return null;
        }
        try {
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.putAll(this.defaults);
            vars.putAll(this.defaultOverrides);
            vars.putAll(this.variables);
            vars.put("uuid", (String)((TemplateMethodModelEx)list -> UUID.randomUUID()));
            StringTemplateLoader templateLoader = new StringTemplateLoader();
            templateLoader.putTemplate(templateName, text);
            this.fmCfg.setTemplateLoader((TemplateLoader)templateLoader);
            StringWriter buf = new StringWriter();
            this.fmCfg.getTemplate(templateName).process(vars, (Writer)buf);
            return buf.toString();
        }
        catch (TemplateException | IOException e) {
            throw new TemplateExecutionException("An error occurred while processing template: " + text, e);
        }
    }

    public synchronized void execute() throws TemplateExecutionException {
        File originalTarget = null;
        try {
            this.steps = this.template.getSteps();
            if (this.steps == null) {
                this.steps = new ArrayList<Step>();
            }
            logger.debug("Generating template to " + this.target);
            if (!this.target.exists()) {
                if (!this.target.mkdirs()) {
                    throw new TemplateExecutionException("Unable to create directory " + this.target);
                }
            } else {
                if (!this.target.isDirectory()) {
                    throw new TemplateExecutionException("Target is not a directory " + this.target);
                }
                File[] existingFiles = this.target.listFiles();
                if (existingFiles != null && existingFiles.length > 0) {
                    originalTarget = this.target;
                    this.target = new TempDir("gentempout");
                }
            }
            if (this.target == null) {
                throw new IllegalArgumentException("Target not set");
            }
            List<TFile> templateFiles = this.template.getFiles();
            if (templateFiles != null && !templateFiles.isEmpty()) {
                this.steps.add(new FilesStep(templateFiles));
            }
            this.defaults.clear();
            this.ignore = new HashSet<Pattern>();
            if (this.template.getIgnore() != null) {
                for (String i : this.template.getIgnore()) {
                    this.ignore.add(Pattern.compile(i));
                }
            }
            if (this.steps != null) {
                for (Step step : this.steps) {
                    step.execute(this);
                }
            }
            if (originalTarget != null) {
                File[] files1 = originalTarget.listFiles();
                if (files1 != null) {
                    for (File file : files1) {
                        FileUtils.delete((File[])new File[]{file});
                    }
                }
                FileUtils.copyFilesInDir((File)this.target, (File)originalTarget);
            }
        }
        catch (IOException e) {
            throw new TemplateExecutionException(e);
        }
        finally {
            if (originalTarget != null) {
                ((TempDir)this.target).close();
            }
        }
    }

    public String resolveVariable(String id) {
        if (this.variables.containsKey(id)) {
            return this.variables.get(id);
        }
        if (this.defaultOverrides.containsKey(id)) {
            return this.defaultOverrides.get(id);
        }
        return this.defaults.get(id);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables.clear();
        if (variables != null) {
            this.addVariables(variables);
        }
    }

    public String getDefaultValue(String key) {
        return this.defaultOverrides.get(key);
    }

    public Map<String, String> getDefaultOverrides() {
        return this.defaultOverrides;
    }

    public void setDefaultOverrides(Map<String, String> defaultOverrides) {
        this.defaultOverrides.clear();
        this.addDefault(defaultOverrides);
    }

    public void addDefault(Map<String, String> defaults) {
        this.defaultOverrides.putAll(defaults);
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    public void setVariable(String id, String val) {
        this.variables.put(id, val);
    }

    public String getVariable(String id) {
        return this.variables.get(id);
    }

    public void addVariables(Map<String, String> vars) {
        this.variables.putAll(vars);
    }

    public boolean containsVariable(String id) {
        return this.variables.containsKey(id);
    }

    public boolean isNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeadless(boolean headless) {
        this.isHeadless = headless;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }
}

