/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis;

import com.aeontronix.genesis.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class ZipResourceLoader
implements ResourceLoader {
    private File file;

    public ZipResourceLoader(File file) {
        this.file = file;
    }

    @Override
    public Set<String> listFiles(String resourcePath) throws IOException {
        HashSet<String> files = new HashSet<String>();
        try (ZipFile zip = new ZipFile(this.file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String path = zipEntry.getName();
                if (zipEntry.isDirectory() || !path.startsWith(resourcePath)) continue;
                if ((path = path.substring(resourcePath.length())).startsWith("/")) {
                    path = path.substring(1);
                }
                files.add(path);
            }
        }
        return files;
    }

    @Override
    public InputStream loadResource(String resourcePath) throws IOException {
        ZipFile zip = new ZipFile(this.file);
        ZipEntry entry = zip.getEntry(resourcePath);
        if (entry != null) {
            return new ZipStreamWrapper(zip, zip.getInputStream(entry));
        }
        return null;
    }

    public class ZipStreamWrapper
    extends InputStream {
        private ZipFile zipFile;
        private InputStream is;

        public ZipStreamWrapper(ZipFile zipFile, InputStream is) {
            this.zipFile = zipFile;
            this.is = is;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
            this.zipFile.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }
    }
}

