/*
 * Decompiled with CFR 0.152.
 */
package com.aeontronix.genesis.cli;

import com.aeontronix.genesis.Template;
import com.aeontronix.genesis.TemplateExecutor;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class GenesisCli
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger(GenesisCli.class);
    @CommandLine.Parameters(index="0", description={"template"})
    private String template;
    @CommandLine.Parameters(index="1", description={"target directory"})
    private File target;
    @CommandLine.Option(names={"-a", "--advanced"}, description={"Enable advanced mode"}, defaultValue="false")
    private boolean advanced;
    @CommandLine.Option(names={"-D"})
    private Map<String, String> vars;

    public static void main(String[] args) {
        CommandLine.call((Callable)new GenesisCli(), (String[])args);
    }

    @Override
    public Void call() throws Exception {
        logger.info("Creating template using " + this.template);
        TemplateExecutor executor = new TemplateExecutor(Template.create(this.template), this.target);
        executor.setVariables(this.vars);
        executor.setAdvanced(this.advanced);
        executor.execute();
        return null;
    }
}

